@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account partner.
 * @property changedTime The changed time.
 * @property content The partner content.
 * @property createdTime The created time.
 * @property id The resource id.
 * @property location The resource location.
 * @property metadata The metadata.
 * @property name Gets the resource name.
 * @property partnerType The partner type.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountPartnerResult(
    public val changedTime: String,
    public val content: PartnerContentResponse,
    public val createdTime: String,
    public val id: String,
    public val location: String? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val partnerType: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountPartnerResult):
            GetIntegrationAccountPartnerResult = GetIntegrationAccountPartnerResult(
            changedTime = javaType.changedTime(),
            content = javaType.content().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.PartnerContentResponse.Companion.toKotlin(args0)
            }),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerType = javaType.partnerType(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
