@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The integration account.
 * @property id The resource id.
 * @property integrationServiceEnvironment The integration service environment.
 * @property location The resource location.
 * @property name Gets the resource name.
 * @property sku The sku.
 * @property state The workflow state.
 * @property tags The resource tags.
 * @property type Gets the resource type.
 */
public data class GetIntegrationAccountResult(
    public val id: String,
    public val integrationServiceEnvironment: ResourceReferenceResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val sku: IntegrationAccountSkuResponse? = null,
    public val state: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.GetIntegrationAccountResult):
            GetIntegrationAccountResult = GetIntegrationAccountResult(
            id = javaType.id(),
            integrationServiceEnvironment = javaType.integrationServiceEnvironment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logic.kotlin.outputs.IntegrationAccountSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
