@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The integration account RosettaNet ProcessConfiguration activity settings.
 * @property acknowledgmentOfReceiptSettings The RosettaNet ProcessConfiguration acknowledgement settings.
 * @property activityBehavior The RosettaNet ProcessConfiguration activity behavior.
 * @property activityType The RosettaNet ProcessConfiguration activity type.
 */
public data class RosettaNetPipActivitySettingsResponse(
    public val acknowledgmentOfReceiptSettings: RosettaNetPipAcknowledgmentOfReceiptSettingsResponse,
    public val activityBehavior: RosettaNetPipActivityBehaviorResponse,
    public val activityType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.RosettaNetPipActivitySettingsResponse):
            RosettaNetPipActivitySettingsResponse = RosettaNetPipActivitySettingsResponse(
            acknowledgmentOfReceiptSettings = javaType.acknowledgmentOfReceiptSettings().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipAcknowledgmentOfReceiptSettingsResponse.Companion.toKotlin(args0)
            }),
            activityBehavior = javaType.activityBehavior().let({ args0 ->
                com.pulumi.azurenative.logic.kotlin.outputs.RosettaNetPipActivityBehaviorResponse.Companion.toKotlin(args0)
            }),
            activityType = javaType.activityType(),
        )
    }
}
