@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The WSDL service.
 * @property endpointQualifiedNames The list of endpoints' qualified names.
 * @property qualifiedName The qualified name.
 */
public data class WsdlServiceResponse(
    public val endpointQualifiedNames: List<String>? = null,
    public val qualifiedName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.WsdlServiceResponse):
            WsdlServiceResponse = WsdlServiceResponse(
            endpointQualifiedNames = javaType.endpointQualifiedNames().map({ args0 -> args0 }),
            qualifiedName = javaType.qualifiedName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
