@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The X12 agreement envelope settings.
 * @property controlStandardsId The controls standards id.
 * @property controlVersionNumber The control version number.
 * @property enableDefaultGroupHeaders The value indicating whether to enable default group headers.
 * @property functionalGroupId The functional group id.
 * @property groupControlNumberLowerBound The group control number lower bound.
 * @property groupControlNumberUpperBound The group control number upper bound.
 * @property groupHeaderAgencyCode The group header agency code.
 * @property groupHeaderDateFormat The group header date format.
 * @property groupHeaderTimeFormat The group header time format.
 * @property groupHeaderVersion The group header version.
 * @property interchangeControlNumberLowerBound The interchange  control number lower bound.
 * @property interchangeControlNumberUpperBound The interchange  control number upper bound.
 * @property overwriteExistingTransactionSetControlNumber The value indicating whether to overwrite existing transaction set control number.
 * @property receiverApplicationId The receiver application id.
 * @property rolloverGroupControlNumber The value indicating whether to rollover group control number.
 * @property rolloverInterchangeControlNumber The value indicating whether to rollover interchange control number.
 * @property rolloverTransactionSetControlNumber The value indicating whether to rollover transaction set control number.
 * @property senderApplicationId The sender application id.
 * @property transactionSetControlNumberLowerBound The transaction set control number lower bound.
 * @property transactionSetControlNumberPrefix The transaction set control number prefix.
 * @property transactionSetControlNumberSuffix The transaction set control number suffix.
 * @property transactionSetControlNumberUpperBound The transaction set control number upper bound.
 * @property usageIndicator The usage indicator.
 * @property useControlStandardsIdAsRepetitionCharacter The value indicating whether to use control standards id as repetition character.
 */
public data class X12EnvelopeSettingsResponse(
    public val controlStandardsId: Int,
    public val controlVersionNumber: String,
    public val enableDefaultGroupHeaders: Boolean,
    public val functionalGroupId: String? = null,
    public val groupControlNumberLowerBound: Int,
    public val groupControlNumberUpperBound: Int,
    public val groupHeaderAgencyCode: String,
    public val groupHeaderDateFormat: String,
    public val groupHeaderTimeFormat: String,
    public val groupHeaderVersion: String,
    public val interchangeControlNumberLowerBound: Int,
    public val interchangeControlNumberUpperBound: Int,
    public val overwriteExistingTransactionSetControlNumber: Boolean,
    public val receiverApplicationId: String,
    public val rolloverGroupControlNumber: Boolean,
    public val rolloverInterchangeControlNumber: Boolean,
    public val rolloverTransactionSetControlNumber: Boolean,
    public val senderApplicationId: String,
    public val transactionSetControlNumberLowerBound: Int,
    public val transactionSetControlNumberPrefix: String? = null,
    public val transactionSetControlNumberSuffix: String? = null,
    public val transactionSetControlNumberUpperBound: Int,
    public val usageIndicator: String,
    public val useControlStandardsIdAsRepetitionCharacter: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12EnvelopeSettingsResponse):
            X12EnvelopeSettingsResponse = X12EnvelopeSettingsResponse(
            controlStandardsId = javaType.controlStandardsId(),
            controlVersionNumber = javaType.controlVersionNumber(),
            enableDefaultGroupHeaders = javaType.enableDefaultGroupHeaders(),
            functionalGroupId = javaType.functionalGroupId().map({ args0 -> args0 }).orElse(null),
            groupControlNumberLowerBound = javaType.groupControlNumberLowerBound(),
            groupControlNumberUpperBound = javaType.groupControlNumberUpperBound(),
            groupHeaderAgencyCode = javaType.groupHeaderAgencyCode(),
            groupHeaderDateFormat = javaType.groupHeaderDateFormat(),
            groupHeaderTimeFormat = javaType.groupHeaderTimeFormat(),
            groupHeaderVersion = javaType.groupHeaderVersion(),
            interchangeControlNumberLowerBound = javaType.interchangeControlNumberLowerBound(),
            interchangeControlNumberUpperBound = javaType.interchangeControlNumberUpperBound(),
            overwriteExistingTransactionSetControlNumber = javaType.overwriteExistingTransactionSetControlNumber(),
            receiverApplicationId = javaType.receiverApplicationId(),
            rolloverGroupControlNumber = javaType.rolloverGroupControlNumber(),
            rolloverInterchangeControlNumber = javaType.rolloverInterchangeControlNumber(),
            rolloverTransactionSetControlNumber = javaType.rolloverTransactionSetControlNumber(),
            senderApplicationId = javaType.senderApplicationId(),
            transactionSetControlNumberLowerBound = javaType.transactionSetControlNumberLowerBound(),
            transactionSetControlNumberPrefix = javaType.transactionSetControlNumberPrefix().map({ args0 ->
                args0
            }).orElse(null),
            transactionSetControlNumberSuffix = javaType.transactionSetControlNumberSuffix().map({ args0 ->
                args0
            }).orElse(null),
            transactionSetControlNumberUpperBound = javaType.transactionSetControlNumberUpperBound(),
            usageIndicator = javaType.usageIndicator(),
            useControlStandardsIdAsRepetitionCharacter = javaType.useControlStandardsIdAsRepetitionCharacter(),
        )
    }
}
