@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The X12 agreement security settings.
 * @property authorizationQualifier The authorization qualifier.
 * @property authorizationValue The authorization value.
 * @property passwordValue The password value.
 * @property securityQualifier The security qualifier.
 */
public data class X12SecuritySettingsResponse(
    public val authorizationQualifier: String,
    public val authorizationValue: String? = null,
    public val passwordValue: String? = null,
    public val securityQualifier: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logic.outputs.X12SecuritySettingsResponse):
            X12SecuritySettingsResponse = X12SecuritySettingsResponse(
            authorizationQualifier = javaType.authorizationQualifier(),
            authorizationValue = javaType.authorizationValue().map({ args0 -> args0 }).orElse(null),
            passwordValue = javaType.passwordValue().map({ args0 -> args0 }).orElse(null),
            securityQualifier = javaType.securityQualifier(),
        )
    }
}
