@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.kotlin.outputs.MetricsTagRulesPropertiesResponse
import com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.logz.kotlin.outputs.MetricsTagRulesPropertiesResponse.Companion.toKotlin as metricsTagRulesPropertiesResponseToKotlin
import com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MetricsSourceTagRule].
 */
@PulumiTagMarker
public class MetricsSourceTagRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MetricsSourceTagRuleArgs = MetricsSourceTagRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MetricsSourceTagRuleArgsBuilder.() -> Unit) {
        val builder = MetricsSourceTagRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): MetricsSourceTagRule {
        val builtJavaResource =
            com.pulumi.azurenative.logz.MetricsSourceTagRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MetricsSourceTagRule(builtJavaResource)
    }
}

/**
 * Capture metrics of Azure resources based on ARM tags.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2022-01-01-preview.
 * ## Example Usage
 * ### MetricsSourceTagRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var metricsSourceTagRule = new AzureNative.Logz.MetricsSourceTagRule("metricsSourceTagRule", new()
 *     {
 *         MetricsSourceName = "MetricsSource1",
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         RuleSetName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewMetricsSourceTagRule(ctx, "metricsSourceTagRule", &logz.MetricsSourceTagRuleArgs{
 * 			MetricsSourceName: pulumi.String("MetricsSource1"),
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RuleSetName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.MetricsSourceTagRule;
 * import com.pulumi.azurenative.logz.MetricsSourceTagRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var metricsSourceTagRule = new MetricsSourceTagRule("metricsSourceTagRule", MetricsSourceTagRuleArgs.builder()
 *             .metricsSourceName("MetricsSource1")
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .ruleSetName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:MetricsSourceTagRule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/metricsSource/{metricsSourceName}/tagRules/{ruleSetName}
 * ```
 */
public class MetricsSourceTagRule internal constructor(
    override val javaResource: com.pulumi.azurenative.logz.MetricsSourceTagRule,
) : KotlinCustomResource(javaResource, MetricsSourceTagRuleMapper) {
    /**
     * Name of the rule set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Definition of the properties for a TagRules resource.
     */
    public val properties: Output<MetricsTagRulesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                metricsTagRulesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the rule set.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MetricsSourceTagRuleMapper : ResourceMapper<MetricsSourceTagRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.logz.MetricsSourceTagRule::class == javaResource::class

    override fun map(javaResource: Resource): MetricsSourceTagRule = MetricsSourceTagRule(
        javaResource
            as com.pulumi.azurenative.logz.MetricsSourceTagRule,
    )
}

/**
 * @see [MetricsSourceTagRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MetricsSourceTagRule].
 */
public suspend fun metricsSourceTagRule(
    name: String,
    block: suspend MetricsSourceTagRuleResourceBuilder.() -> Unit,
): MetricsSourceTagRule {
    val builder = MetricsSourceTagRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MetricsSourceTagRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun metricsSourceTagRule(name: String): MetricsSourceTagRule {
    val builder = MetricsSourceTagRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
