@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin

import com.pulumi.azurenative.logz.SubAccountTagRuleArgs.builder
import com.pulumi.azurenative.logz.kotlin.inputs.MonitoringTagRulesPropertiesArgs
import com.pulumi.azurenative.logz.kotlin.inputs.MonitoringTagRulesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Capture logs and metrics of Azure resources based on ARM tags.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### SubAccountTagRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subAccountTagRule = new AzureNative.Logz.SubAccountTagRule("subAccountTagRule", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         RuleSetName = "default",
 *         SubAccountName = "SubAccount1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/logz/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := logz.NewSubAccountTagRule(ctx, "subAccountTagRule", &logz.SubAccountTagRuleArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RuleSetName:       pulumi.String("default"),
 * 			SubAccountName:    pulumi.String("SubAccount1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.logz.SubAccountTagRule;
 * import com.pulumi.azurenative.logz.SubAccountTagRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subAccountTagRule = new SubAccountTagRule("subAccountTagRule", SubAccountTagRuleArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .ruleSetName("default")
 *             .subAccountName("SubAccount1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:logz:SubAccountTagRule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/accounts/{subAccountName}/tagRules/{ruleSetName}
 * ```
 * @property monitorName Monitor resource name
 * @property properties Definition of the properties for a TagRules resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property ruleSetName
 * @property subAccountName Sub Account resource name
 */
public data class SubAccountTagRuleArgs(
    public val monitorName: Output<String>? = null,
    public val properties: Output<MonitoringTagRulesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleSetName: Output<String>? = null,
    public val subAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.SubAccountTagRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.SubAccountTagRuleArgs =
        com.pulumi.azurenative.logz.SubAccountTagRuleArgs.builder()
            .monitorName(monitorName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 }))
            .subAccountName(subAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubAccountTagRuleArgs].
 */
@PulumiTagMarker
public class SubAccountTagRuleArgsBuilder internal constructor() {
    private var monitorName: Output<String>? = null

    private var properties: Output<MonitoringTagRulesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleSetName: Output<String>? = null

    private var subAccountName: Output<String>? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("tqsllkohdqsaxthh")
    public suspend fun monitorName(`value`: Output<String>) {
        this.monitorName = value
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("ytqjjbarufxphysr")
    public suspend fun properties(`value`: Output<MonitoringTagRulesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pjjadoxalwkkdekj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("lidjsfkunknykwmh")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("eqxkbjjjaorpsvtb")
    public suspend fun subAccountName(`value`: Output<String>) {
        this.subAccountName = value
    }

    /**
     * @param value Monitor resource name
     */
    @JvmName("jnfclnwlonkekwcw")
    public suspend fun monitorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorName = mapped
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("uatsdmxfqttquonl")
    public suspend fun properties(`value`: MonitoringTagRulesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Definition of the properties for a TagRules resource.
     */
    @JvmName("xaixgtemtujtfrno")
    public suspend
    fun properties(argument: suspend MonitoringTagRulesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringTagRulesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ejoahkghrniyhmpy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("iqdualqkrnfpyuea")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("ldtrdpriyvuxgatf")
    public suspend fun subAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subAccountName = mapped
    }

    internal fun build(): SubAccountTagRuleArgs = SubAccountTagRuleArgs(
        monitorName = monitorName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        ruleSetName = ruleSetName,
        subAccountName = subAccountName,
    )
}
