@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.ListSubAccountMonitoredResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property monitorName Monitor resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subAccountName Sub Account resource name
 */
public data class ListSubAccountMonitoredResourcesPlainArgs(
    public val monitorName: String,
    public val resourceGroupName: String,
    public val subAccountName: String,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.ListSubAccountMonitoredResourcesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.logz.inputs.ListSubAccountMonitoredResourcesPlainArgs =
        com.pulumi.azurenative.logz.inputs.ListSubAccountMonitoredResourcesPlainArgs.builder()
            .monitorName(monitorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .subAccountName(subAccountName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSubAccountMonitoredResourcesPlainArgs].
 */
@PulumiTagMarker
public class ListSubAccountMonitoredResourcesPlainArgsBuilder internal constructor() {
    private var monitorName: String? = null

    private var resourceGroupName: String? = null

    private var subAccountName: String? = null

    /**
     * @param value Monitor resource name
     */
    @JvmName("bgpatxpwuxnmswcv")
    public suspend fun monitorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.monitorName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oirlxhytpolhmovt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sub Account resource name
     */
    @JvmName("ithjqlyensxxskux")
    public suspend fun subAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.subAccountName = mapped
    }

    internal fun build(): ListSubAccountMonitoredResourcesPlainArgs =
        ListSubAccountMonitoredResourcesPlainArgs(
            monitorName = monitorName ?: throw PulumiNullFieldException("monitorName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            subAccountName = subAccountName ?: throw PulumiNullFieldException("subAccountName"),
        )
}
