@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.inputs

import com.pulumi.azurenative.logz.inputs.MetricsTagRulesPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Definition of the properties for a TagRules resource.
 * @property metricRules
 * @property sendMetrics Flag specifying if metrics from Azure resources should be sent for the Monitor resource.
 */
public data class MetricsTagRulesPropertiesArgs(
    public val metricRules: Output<List<MetricRulesArgs>>? = null,
    public val sendMetrics: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.logz.inputs.MetricsTagRulesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.logz.inputs.MetricsTagRulesPropertiesArgs =
        com.pulumi.azurenative.logz.inputs.MetricsTagRulesPropertiesArgs.builder()
            .metricRules(
                metricRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sendMetrics(sendMetrics?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricsTagRulesPropertiesArgs].
 */
@PulumiTagMarker
public class MetricsTagRulesPropertiesArgsBuilder internal constructor() {
    private var metricRules: Output<List<MetricRulesArgs>>? = null

    private var sendMetrics: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("khkaqahfaohyyvfb")
    public suspend fun metricRules(`value`: Output<List<MetricRulesArgs>>) {
        this.metricRules = value
    }

    @JvmName("jkuttdqwlebmlcpx")
    public suspend fun metricRules(vararg values: Output<MetricRulesArgs>) {
        this.metricRules = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rthxnlbabjxmhwsh")
    public suspend fun metricRules(values: List<Output<MetricRulesArgs>>) {
        this.metricRules = Output.all(values)
    }

    /**
     * @param value Flag specifying if metrics from Azure resources should be sent for the Monitor resource.
     */
    @JvmName("wdhgfbseymlbkhwh")
    public suspend fun sendMetrics(`value`: Output<Boolean>) {
        this.sendMetrics = value
    }

    /**
     * @param value
     */
    @JvmName("efhlwypoqkutophc")
    public suspend fun metricRules(`value`: List<MetricRulesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("umgyyshiwmhpkmav")
    public suspend fun metricRules(argument: List<suspend MetricRulesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { MetricRulesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.metricRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("egmwxdyirbvpqcbr")
    public suspend fun metricRules(vararg argument: suspend MetricRulesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { MetricRulesArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.metricRules = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dcdxxjklhgivcmum")
    public suspend fun metricRules(argument: suspend MetricRulesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MetricRulesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metricRules = mapped
    }

    /**
     * @param values
     */
    @JvmName("ftshcktjiuachxeg")
    public suspend fun metricRules(vararg values: MetricRulesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricRules = mapped
    }

    /**
     * @param value Flag specifying if metrics from Azure resources should be sent for the Monitor resource.
     */
    @JvmName("cvoordsjeokxmhyi")
    public suspend fun sendMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendMetrics = mapped
    }

    internal fun build(): MetricsTagRulesPropertiesArgs = MetricsTagRulesPropertiesArgs(
        metricRules = metricRules,
        sendMetrics = sendMetrics,
    )
}
