@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of the properties for a TagRules resource.
 * @property metricRules
 * @property provisioningState Flag specifying if the resource provisioning state as tracked by ARM.
 * @property sendMetrics Flag specifying if metrics from Azure resources should be sent for the Monitor resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 */
public data class MetricsTagRulesPropertiesResponse(
    public val metricRules: List<MetricRulesResponse>? = null,
    public val provisioningState: String,
    public val sendMetrics: Boolean? = null,
    public val systemData: SystemDataResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.MetricsTagRulesPropertiesResponse):
            MetricsTagRulesPropertiesResponse = MetricsTagRulesPropertiesResponse(
            metricRules = javaType.metricRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.logz.kotlin.outputs.MetricRulesResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            sendMetrics = javaType.sendMetrics().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.logz.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
