@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.logz.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VM Resource Ids
 * @property agentVersion Version of the Logz agent installed on the VM.
 * @property id Request of a list vm host update operation.
 */
public data class VMResourcesResponse(
    public val agentVersion: String? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.logz.outputs.VMResourcesResponse):
            VMResourcesResponse = VMResourcesResponse(
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
