@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.m365securityandcompliance.kotlin

import com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs.builder
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.m365securityandcompliance.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2021-03-25-preview. Prior API version in Azure Native 1.x: 2021-03-25-preview.
 * ## Example Usage
 * ### PrivateEndpointConnection_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnectionsForSCCPowershell = new AzureNative.M365SecurityAndCompliance.PrivateEndpointConnectionsForSCCPowershell("privateEndpointConnectionsForSCCPowershell", new()
 *     {
 *         PrivateEndpointConnectionName = "myConnection",
 *         PrivateLinkServiceConnectionState = new AzureNative.M365SecurityAndCompliance.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = AzureNative.M365SecurityAndCompliance.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "rgname",
 *         ResourceName = "service1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/m365securityandcompliance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := m365securityandcompliance.NewPrivateEndpointConnectionsForSCCPowershell(ctx, "privateEndpointConnectionsForSCCPowershell", &m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myConnection"),
 * 			PrivateLinkServiceConnectionState: &m365securityandcompliance.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String(m365securityandcompliance.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgname"),
 * 			ResourceName:      pulumi.String("service1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershell;
 * import com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs;
 * import com.pulumi.azurenative.m365securityandcompliance.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnectionsForSCCPowershell = new PrivateEndpointConnectionsForSCCPowershell("privateEndpointConnectionsForSCCPowershell", PrivateEndpointConnectionsForSCCPowershellArgs.builder()
 *             .privateEndpointConnectionName("myConnection")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Auto-Approved")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rgname")
 *             .resourceName("service1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:m365securityandcompliance:PrivateEndpointConnectionsForSCCPowershell myConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.M365SecurityAndCompliance/privateLinkServicesForSCCPowershell/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group that contains the service instance.
 * @property resourceName The name of the service instance.
 */
public data class PrivateEndpointConnectionsForSCCPowershellArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs> {
    override fun toJava():
        com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs =
        com.pulumi.azurenative.m365securityandcompliance.PrivateEndpointConnectionsForSCCPowershellArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionsForSCCPowershellArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionsForSCCPowershellArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("rtoodmnvvaddnnco")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("pxoccmpupiejlehs")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("nwsqvighydrqsisg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("cydntxyoyvwccocj")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("wosobwetpfwgxnqi")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("xlgbrlrbvvdeimmt")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("rapqggpovijmqiri")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group that contains the service instance.
     */
    @JvmName("gqpmdweqgpbtuknb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service instance.
     */
    @JvmName("gsaayrayldpyppmy")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): PrivateEndpointConnectionsForSCCPowershellArgs =
        PrivateEndpointConnectionsForSCCPowershellArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
}
