@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.MachinelearningFunctions.getCommitmentPlanPlain
import com.pulumi.azurenative.machinelearning.MachinelearningFunctions.getWebServicePlain
import com.pulumi.azurenative.machinelearning.MachinelearningFunctions.getWorkspacePlain
import com.pulumi.azurenative.machinelearning.MachinelearningFunctions.listWorkspaceKeysPlain
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetCommitmentPlanPlainArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetCommitmentPlanPlainArgsBuilder
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetWebServicePlainArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetWebServicePlainArgsBuilder
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.machinelearning.kotlin.inputs.ListWorkspaceKeysPlainArgs
import com.pulumi.azurenative.machinelearning.kotlin.inputs.ListWorkspaceKeysPlainArgsBuilder
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetCommitmentPlanResult
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetWebServiceResult
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.machinelearning.kotlin.outputs.ListWorkspaceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetCommitmentPlanResult.Companion.toKotlin as getCommitmentPlanResultToKotlin
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetWebServiceResult.Companion.toKotlin as getWebServiceResultToKotlin
import com.pulumi.azurenative.machinelearning.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.machinelearning.kotlin.outputs.ListWorkspaceKeysResult.Companion.toKotlin as listWorkspaceKeysResultToKotlin

public object MachinelearningFunctions {
    /**
     * Retrieve an Azure ML commitment plan by its subscription, resource group and name.
     * Azure REST API version: 2016-05-01-preview.
     * @param argument null
     * @return An Azure ML commitment plan resource.
     */
    public suspend fun getCommitmentPlan(argument: GetCommitmentPlanPlainArgs):
        GetCommitmentPlanResult =
        getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(argument.toJava()).await())

    /**
     * @see [getCommitmentPlan].
     * @param commitmentPlanName The Azure ML commitment plan name.
     * @param resourceGroupName The resource group name.
     * @return An Azure ML commitment plan resource.
     */
    public suspend fun getCommitmentPlan(commitmentPlanName: String, resourceGroupName: String):
        GetCommitmentPlanResult {
        val argument = GetCommitmentPlanPlainArgs(
            commitmentPlanName = commitmentPlanName,
            resourceGroupName = resourceGroupName,
        )
        return getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(argument.toJava()).await())
    }

    /**
     * @see [getCommitmentPlan].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearning&#46;kotlin&#46;inputs&#46;GetCommitmentPlanPlainArgs].
     * @return An Azure ML commitment plan resource.
     */
    public suspend
    fun getCommitmentPlan(argument: suspend GetCommitmentPlanPlainArgsBuilder.() -> Unit):
        GetCommitmentPlanResult {
        val builder = GetCommitmentPlanPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCommitmentPlanResultToKotlin(getCommitmentPlanPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Web Service Definition as specified by a subscription, resource group, and name. Note that the storage credentials and web service keys are not returned by this call. To get the web service access keys, call List Keys.
     * Azure REST API version: 2017-01-01.
     * Other available API versions: 2016-05-01-preview.
     * @param argument null
     * @return Instance of an Azure ML web service resource.
     */
    public suspend fun getWebService(argument: GetWebServicePlainArgs): GetWebServiceResult =
        getWebServiceResultToKotlin(getWebServicePlain(argument.toJava()).await())

    /**
     * @see [getWebService].
     * @param region The region for which encrypted credential parameters are valid.
     * @param resourceGroupName Name of the resource group in which the web service is located.
     * @param webServiceName The name of the web service.
     * @return Instance of an Azure ML web service resource.
     */
    public suspend fun getWebService(
        region: String? = null,
        resourceGroupName: String,
        webServiceName: String,
    ): GetWebServiceResult {
        val argument = GetWebServicePlainArgs(
            region = region,
            resourceGroupName = resourceGroupName,
            webServiceName = webServiceName,
        )
        return getWebServiceResultToKotlin(getWebServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getWebService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearning&#46;kotlin&#46;inputs&#46;GetWebServicePlainArgs].
     * @return Instance of an Azure ML web service resource.
     */
    public suspend fun getWebService(argument: suspend GetWebServicePlainArgsBuilder.() -> Unit):
        GetWebServiceResult {
        val builder = GetWebServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebServiceResultToKotlin(getWebServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified machine learning workspace.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group to which the machine learning workspace belongs.
     * @param workspaceName The name of the machine learning workspace.
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearning&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return An object that represents a machine learning workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * List the authorization keys associated with this workspace.
     * Azure REST API version: 2019-10-01.
     * @param argument null
     * @return Workspace authorization keys for a workspace.
     */
    public suspend fun listWorkspaceKeys(argument: ListWorkspaceKeysPlainArgs):
        ListWorkspaceKeysResult =
        listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceKeys].
     * @param resourceGroupName The name of the resource group to which the machine learning workspace belongs.
     * @param workspaceName The name of the machine learning workspace.
     * @return Workspace authorization keys for a workspace.
     */
    public suspend fun listWorkspaceKeys(resourceGroupName: String, workspaceName: String):
        ListWorkspaceKeysResult {
        val argument = ListWorkspaceKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;machinelearning&#46;kotlin&#46;inputs&#46;ListWorkspaceKeysPlainArgs].
     * @return Workspace authorization keys for a workspace.
     */
    public suspend
    fun listWorkspaceKeys(argument: suspend ListWorkspaceKeysPlainArgsBuilder.() -> Unit):
        ListWorkspaceKeysResult {
        val builder = ListWorkspaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(builtArgument.toJava()).await())
    }
}
