@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin

import com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServicePropertiesForGraphResponse
import com.pulumi.azurenative.machinelearning.kotlin.outputs.WebServicePropertiesForGraphResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [WebService].
 */
@PulumiTagMarker
public class WebServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebServiceArgs = WebServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebServiceArgsBuilder.() -> Unit) {
        val builder = WebServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebService {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearning.WebService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebService(builtJavaResource)
    }
}

/**
 * Instance of an Azure ML web service resource.
 * Azure REST API version: 2017-01-01. Prior API version in Azure Native 1.x: 2017-01-01.
 * Other available API versions: 2016-05-01-preview.
 * ## Example Usage
 * ### PUT WebService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webService = new AzureNative.MachineLearning.WebService("webService", new()
 *     {
 *         Location = "West US",
 *         Properties = new AzureNative.MachineLearning.Inputs.WebServicePropertiesForGraphArgs
 *         {
 *             Assets =
 *             {
 *                 { "asset1", new AzureNative.MachineLearning.Inputs.AssetItemArgs
 *                 {
 *                     LocationInfo = new AzureNative.MachineLearning.Inputs.BlobLocationArgs
 *                     {
 *                         Credentials = "",
 *                         Uri = "aml://module/moduleId-1",
 *                     },
 *                     Name = "Execute R Script",
 *                     Type = AzureNative.MachineLearning.AssetType.Module,
 *                 } },
 *                 { "asset2", new AzureNative.MachineLearning.Inputs.AssetItemArgs
 *                 {
 *                     LocationInfo = new AzureNative.MachineLearning.Inputs.BlobLocationArgs
 *                     {
 *                         Credentials = "",
 *                         Uri = "aml://module/moduleId-2",
 *                     },
 *                     Name = "Import Data",
 *                     Type = AzureNative.MachineLearning.AssetType.Module,
 *                 } },
 *             },
 *             CommitmentPlan = new AzureNative.MachineLearning.Inputs.CommitmentPlanArgs
 *             {
 *                 Id = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.MachineLearning/commitmentPlans/commitmentPlanName",
 *             },
 *             Description = "Web Service Description",
 *             Diagnostics = new AzureNative.MachineLearning.Inputs.DiagnosticsConfigurationArgs
 *             {
 *                 Level = AzureNative.MachineLearning.DiagnosticsLevel.None,
 *             },
 *             ExampleRequest = new AzureNative.MachineLearning.Inputs.ExampleRequestArgs
 *             {
 *                 Inputs =
 *                 {
 *                     { "input1", new[]
 *                     {
 *                         new[]
 *                         {
 *                             "age",
 *                         },
 *                         new[]
 *                         {
 *                             "workclass",
 *                         },
 *                         new[]
 *                         {
 *                             "fnlwgt",
 *                         },
 *                         new[]
 *                         {
 *                             "education",
 *                         },
 *                         new[]
 *                         {
 *                             "education-num",
 *                         },
 *                     } },
 *                 },
 *             },
 *             ExposeSampleData = true,
 *             Input = new AzureNative.MachineLearning.Inputs.ServiceInputOutputSpecificationArgs
 *             {
 *                 Description = "",
 *                 Properties =
 *                 {
 *                     { "input1", new AzureNative.MachineLearning.Inputs.TableSpecificationArgs
 *                     {
 *                         Description = "",
 *                         Properties =
 *                         {
 *                             { "column_name", new AzureNative.MachineLearning.Inputs.ColumnSpecificationArgs
 *                             {
 *                                 Type = AzureNative.MachineLearning.ColumnType.String,
 *                                 XMsIsnullable = false,
 *                             } },
 *                         },
 *                         Title = "",
 *                         Type = "object",
 *                     } },
 *                 },
 *                 Title = "",
 *                 Type = "object",
 *             },
 *             MachineLearningWorkspace = new AzureNative.MachineLearning.Inputs.MachineLearningWorkspaceArgs
 *             {
 *                 Id = "workspaceId",
 *             },
 *             Output = new AzureNative.MachineLearning.Inputs.ServiceInputOutputSpecificationArgs
 *             {
 *                 Description = "",
 *                 Properties =
 *                 {
 *                     { "output1", new AzureNative.MachineLearning.Inputs.TableSpecificationArgs
 *                     {
 *                         Description = "",
 *                         Properties =
 *                         {
 *                             { "age", new AzureNative.MachineLearning.Inputs.ColumnSpecificationArgs
 *                             {
 *                                 Format = AzureNative.MachineLearning.ColumnFormat.Int32,
 *                                 Type = AzureNative.MachineLearning.ColumnType.Integer,
 *                                 XMsIsnullable = true,
 *                             } },
 *                             { "workclass", new AzureNative.MachineLearning.Inputs.ColumnSpecificationArgs
 *                             {
 *                                 Type = AzureNative.MachineLearning.ColumnType.String,
 *                                 XMsIsnullable = false,
 *                             } },
 *                         },
 *                         Title = "",
 *                         Type = "object",
 *                     } },
 *                 },
 *                 Title = "",
 *                 Type = "object",
 *             },
 *             Package = new AzureNative.MachineLearning.Inputs.GraphPackageArgs
 *             {
 *                 Edges = new[]
 *                 {
 *                     new AzureNative.MachineLearning.Inputs.GraphEdgeArgs
 *                     {
 *                         SourceNodeId = "node2",
 *                         SourcePortId = "Results dataset",
 *                         TargetNodeId = "node1",
 *                         TargetPortId = "Dataset2",
 *                     },
 *                     new AzureNative.MachineLearning.Inputs.GraphEdgeArgs
 *                     {
 *                         SourceNodeId = "node3",
 *                         TargetNodeId = "node1",
 *                         TargetPortId = "Dataset1",
 *                     },
 *                     new AzureNative.MachineLearning.Inputs.GraphEdgeArgs
 *                     {
 *                         SourceNodeId = "node1",
 *                         SourcePortId = "Result Dataset",
 *                         TargetNodeId = "node4",
 *                     },
 *                 },
 *                 GraphParameters = null,
 *                 Nodes =
 *                 {
 *                     { "node1", new AzureNative.MachineLearning.Inputs.GraphNodeArgs
 *                     {
 *                         AssetId = "asset1",
 *                         Parameters =
 *                         {
 *                             { "R Script", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "",
 *                                 Value = "The R Script",
 *                             } },
 *                             { "R Version", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "",
 *                                 Value = "CRAN R 3.1.0",
 *                             } },
 *                         },
 *                     } },
 *                     { "node2", new AzureNative.MachineLearning.Inputs.GraphNodeArgs
 *                     {
 *                         AssetId = "asset2",
 *                         Parameters =
 *                         {
 *                             { "Account Key", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "TheThumbprint",
 *                                 Value = "Encrypted Key",
 *                             } },
 *                             { "Account Name", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "",
 *                                 Value = "accountName",
 *                             } },
 *                             { "Please Specify Authentication Type", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "",
 *                                 Value = "Account",
 *                             } },
 *                             { "Please Specify Data Source", new AzureNative.MachineLearning.Inputs.WebServiceParameterArgs
 *                             {
 *                                 CertificateThumbprint = "",
 *                                 Value = "AzureBlobStorage",
 *                             } },
 *                         },
 *                     } },
 *                     { "node3", new AzureNative.MachineLearning.Inputs.GraphNodeArgs
 *                     {
 *                         InputId = "input1",
 *                     } },
 *                     { "node4", new AzureNative.MachineLearning.Inputs.GraphNodeArgs
 *                     {
 *                         OutputId = "output1",
 *                     } },
 *                 },
 *             },
 *             PackageType = "Graph",
 *             Parameters = null,
 *             PayloadsInBlobStorage = false,
 *             ReadOnly = false,
 *             RealtimeConfiguration = new AzureNative.MachineLearning.Inputs.RealtimeConfigurationArgs
 *             {
 *                 MaxConcurrentCalls = 4,
 *             },
 *             StorageAccount = new AzureNative.MachineLearning.Inputs.StorageAccountArgs
 *             {
 *                 Key = "Storage_Key",
 *                 Name = "Storage_Name",
 *             },
 *             Title = "Web Service Title",
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         WebServiceName = "TargetWebServiceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearning/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearning.NewWebService(ctx, "webService", &machinelearning.WebServiceArgs{
 * 			Location: pulumi.String("West US"),
 * 			Properties: &machinelearning.WebServicePropertiesForGraphArgs{
 * 				Assets: machinelearning.AssetItemMap{
 * 					"asset1": &machinelearning.AssetItemArgs{
 * 						LocationInfo: &machinelearning.BlobLocationArgs{
 * 							Credentials: pulumi.String(""),
 * 							Uri:         pulumi.String("aml://module/moduleId-1"),
 * 						},
 * 						Name: pulumi.String("Execute R Script"),
 * 						Type: pulumi.String(machinelearning.AssetTypeModule),
 * 					},
 * 					"asset2": &machinelearning.AssetItemArgs{
 * 						LocationInfo: &machinelearning.BlobLocationArgs{
 * 							Credentials: pulumi.String(""),
 * 							Uri:         pulumi.String("aml://module/moduleId-2"),
 * 						},
 * 						Name: pulumi.String("Import Data"),
 * 						Type: pulumi.String(machinelearning.AssetTypeModule),
 * 					},
 * 				},
 * 				CommitmentPlan: &machinelearning.CommitmentPlanTypeArgs{
 * 					Id: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.MachineLearning/commitmentPlans/commitmentPlanName"),
 * 				},
 * 				Description: pulumi.String("Web Service Description"),
 * 				Diagnostics: &machinelearning.DiagnosticsConfigurationArgs{
 * 					Level: pulumi.String(machinelearning.DiagnosticsLevelNone),
 * 				},
 * 				ExampleRequest: &machinelearning.ExampleRequestArgs{
 * 					Inputs: pulumi.ArrayArrayMap{
 * 						"input1": pulumi.ArrayArray{
 * 							pulumi.Array{
 * 								pulumi.Any("age"),
 * 							},
 * 							pulumi.Array{
 * 								pulumi.Any("workclass"),
 * 							},
 * 							pulumi.Array{
 * 								pulumi.Any("fnlwgt"),
 * 							},
 * 							pulumi.Array{
 * 								pulumi.Any("education"),
 * 							},
 * 							pulumi.Array{
 * 								pulumi.Any("education-num"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				ExposeSampleData: pulumi.Bool(true),
 * 				Input: &machinelearning.ServiceInputOutputSpecificationArgs{
 * 					Description: pulumi.String(""),
 * 					Properties: machinelearning.TableSpecificationMap{
 * 						"input1": &machinelearning.TableSpecificationArgs{
 * 							Description: pulumi.String(""),
 * 							Properties: machinelearning.ColumnSpecificationMap{
 * 								"column_name": &machinelearning.ColumnSpecificationArgs{
 * 									Type:          pulumi.String(machinelearning.ColumnTypeString),
 * 									XMsIsnullable: pulumi.Bool(false),
 * 								},
 * 							},
 * 							Title: pulumi.String(""),
 * 							Type:  pulumi.String("object"),
 * 						},
 * 					},
 * 					Title: pulumi.String(""),
 * 					Type:  pulumi.String("object"),
 * 				},
 * 				MachineLearningWorkspace: &machinelearning.MachineLearningWorkspaceArgs{
 * 					Id: pulumi.String("workspaceId"),
 * 				},
 * 				Output: &machinelearning.ServiceInputOutputSpecificationArgs{
 * 					Description: pulumi.String(""),
 * 					Properties: machinelearning.TableSpecificationMap{
 * 						"output1": &machinelearning.TableSpecificationArgs{
 * 							Description: pulumi.String(""),
 * 							Properties: machinelearning.ColumnSpecificationMap{
 * 								"age": &machinelearning.ColumnSpecificationArgs{
 * 									Format:        pulumi.String(machinelearning.ColumnFormatInt32),
 * 									Type:          pulumi.String(machinelearning.ColumnTypeInteger),
 * 									XMsIsnullable: pulumi.Bool(true),
 * 								},
 * 								"workclass": &machinelearning.ColumnSpecificationArgs{
 * 									Type:          pulumi.String(machinelearning.ColumnTypeString),
 * 									XMsIsnullable: pulumi.Bool(false),
 * 								},
 * 							},
 * 							Title: pulumi.String(""),
 * 							Type:  pulumi.String("object"),
 * 						},
 * 					},
 * 					Title: pulumi.String(""),
 * 					Type:  pulumi.String("object"),
 * 				},
 * 				Package: &machinelearning.GraphPackageArgs{
 * 					Edges: machinelearning.GraphEdgeArray{
 * 						&machinelearning.GraphEdgeArgs{
 * 							SourceNodeId: pulumi.String("node2"),
 * 							SourcePortId: pulumi.String("Results dataset"),
 * 							TargetNodeId: pulumi.String("node1"),
 * 							TargetPortId: pulumi.String("Dataset2"),
 * 						},
 * 						&machinelearning.GraphEdgeArgs{
 * 							SourceNodeId: pulumi.String("node3"),
 * 							TargetNodeId: pulumi.String("node1"),
 * 							TargetPortId: pulumi.String("Dataset1"),
 * 						},
 * 						&machinelearning.GraphEdgeArgs{
 * 							SourceNodeId: pulumi.String("node1"),
 * 							SourcePortId: pulumi.String("Result Dataset"),
 * 							TargetNodeId: pulumi.String("node4"),
 * 						},
 * 					},
 * 					GraphParameters: nil,
 * 					Nodes: machinelearning.GraphNodeMap{
 * 						"node1": &machinelearning.GraphNodeArgs{
 * 							AssetId: pulumi.String("asset1"),
 * 							Parameters: machinelearning.WebServiceParameterMap{
 * 								"R Script": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String(""),
 * 									Value:                 pulumi.Any("The R Script"),
 * 								},
 * 								"R Version": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String(""),
 * 									Value:                 pulumi.Any("CRAN R 3.1.0"),
 * 								},
 * 							},
 * 						},
 * 						"node2": &machinelearning.GraphNodeArgs{
 * 							AssetId: pulumi.String("asset2"),
 * 							Parameters: machinelearning.WebServiceParameterMap{
 * 								"Account Key": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String("TheThumbprint"),
 * 									Value:                 pulumi.Any("Encrypted Key"),
 * 								},
 * 								"Account Name": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String(""),
 * 									Value:                 pulumi.Any("accountName"),
 * 								},
 * 								"Please Specify Authentication Type": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String(""),
 * 									Value:                 pulumi.Any("Account"),
 * 								},
 * 								"Please Specify Data Source": &machinelearning.WebServiceParameterArgs{
 * 									CertificateThumbprint: pulumi.String(""),
 * 									Value:                 pulumi.Any("AzureBlobStorage"),
 * 								},
 * 							},
 * 						},
 * 						"node3": &machinelearning.GraphNodeArgs{
 * 							InputId: pulumi.String("input1"),
 * 						},
 * 						"node4": &machinelearning.GraphNodeArgs{
 * 							OutputId: pulumi.String("output1"),
 * 						},
 * 					},
 * 				},
 * 				PackageType:           pulumi.String("Graph"),
 * 				Parameters:            nil,
 * 				PayloadsInBlobStorage: pulumi.Bool(false),
 * 				ReadOnly:              pulumi.Bool(false),
 * 				RealtimeConfiguration: &machinelearning.RealtimeConfigurationArgs{
 * 					MaxConcurrentCalls: pulumi.Int(4),
 * 				},
 * 				StorageAccount: &machinelearning.StorageAccountArgs{
 * 					Key:  pulumi.String("Storage_Key"),
 * 					Name: pulumi.String("Storage_Name"),
 * 				},
 * 				Title: pulumi.String("Web Service Title"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			WebServiceName: pulumi.String("TargetWebServiceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearning.WebService;
 * import com.pulumi.azurenative.machinelearning.WebServiceArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.WebServicePropertiesForGraphArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.CommitmentPlanArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.DiagnosticsConfigurationArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.ExampleRequestArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.ServiceInputOutputSpecificationArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.MachineLearningWorkspaceArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.GraphPackageArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.RealtimeConfigurationArgs;
 * import com.pulumi.azurenative.machinelearning.inputs.StorageAccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webService = new WebService("webService", WebServiceArgs.builder()
 *             .location("West US")
 *             .properties(WebServicePropertiesForGraphArgs.builder()
 *                 .assets(Map.ofEntries(
 *                     Map.entry("asset1", Map.ofEntries(
 *                         Map.entry("locationInfo", Map.ofEntries(
 *                             Map.entry("credentials", ""),
 *                             Map.entry("uri", "aml://module/moduleId-1")
 *                         )),
 *                         Map.entry("name", "Execute R Script"),
 *                         Map.entry("type", "Module")
 *                     )),
 *                     Map.entry("asset2", Map.ofEntries(
 *                         Map.entry("locationInfo", Map.ofEntries(
 *                             Map.entry("credentials", ""),
 *                             Map.entry("uri", "aml://module/moduleId-2")
 *                         )),
 *                         Map.entry("name", "Import Data"),
 *                         Map.entry("type", "Module")
 *                     ))
 *                 ))
 *                 .commitmentPlan(CommitmentPlanArgs.builder()
 *                     .id("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.MachineLearning/commitmentPlans/commitmentPlanName")
 *                     .build())
 *                 .description("Web Service Description")
 *                 .diagnostics(DiagnosticsConfigurationArgs.builder()
 *                     .level("None")
 *                     .build())
 *                 .exampleRequest(ExampleRequestArgs.builder()
 *                     .inputs(Map.of("input1",
 *                         "age",
 *                         "workclass",
 *                         "fnlwgt",
 *                         "education",
 *                         "education-num"))
 *                     .build())
 *                 .exposeSampleData(true)
 *                 .input(ServiceInputOutputSpecificationArgs.builder()
 *                     .description("")
 *                     .properties(Map.of("input1", Map.ofEntries(
 *                         Map.entry("description", ""),
 *                         Map.entry("properties", Map.of("column_name", Map.ofEntries(
 *                             Map.entry("type", "String"),
 *                             Map.entry("xMsIsnullable", false)
 *                         ))),
 *                         Map.entry("title", ""),
 *                         Map.entry("type", "object")
 *                     )))
 *                     .title("")
 *                     .type("object")
 *                     .build())
 *                 .machineLearningWorkspace(MachineLearningWorkspaceArgs.builder()
 *                     .id("workspaceId")
 *                     .build())
 *                 .output(ServiceInputOutputSpecificationArgs.builder()
 *                     .description("")
 *                     .properties(Map.of("output1", Map.ofEntries(
 *                         Map.entry("description", ""),
 *                         Map.entry("properties", Map.ofEntries(
 *                             Map.entry("age", Map.ofEntries(
 *                                 Map.entry("format", "Int32"),
 *                                 Map.entry("type", "Integer"),
 *                                 Map.entry("xMsIsnullable", true)
 *                             )),
 *                             Map.entry("workclass", Map.ofEntries(
 *                                 Map.entry("type", "String"),
 *                                 Map.entry("xMsIsnullable", false)
 *                             ))
 *                         )),
 *                         Map.entry("title", ""),
 *                         Map.entry("type", "object")
 *                     )))
 *                     .title("")
 *                     .type("object")
 *                     .build())
 *                 .package_(GraphPackageArgs.builder()
 *                     .edges(
 *                         GraphEdgeArgs.builder()
 *                             .sourceNodeId("node2")
 *                             .sourcePortId("Results dataset")
 *                             .targetNodeId("node1")
 *                             .targetPortId("Dataset2")
 *                             .build(),
 *                         GraphEdgeArgs.builder()
 *                             .sourceNodeId("node3")
 *                             .targetNodeId("node1")
 *                             .targetPortId("Dataset1")
 *                             .build(),
 *                         GraphEdgeArgs.builder()
 *                             .sourceNodeId("node1")
 *                             .sourcePortId("Result Dataset")
 *                             .targetNodeId("node4")
 *                             .build())
 *                     .graphParameters()
 *                     .nodes(Map.ofEntries(
 *                         Map.entry("node1", Map.ofEntries(
 *                             Map.entry("assetId", "asset1"),
 *                             Map.entry("parameters", Map.ofEntries(
 *                                 Map.entry("R Script", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", ""),
 *                                     Map.entry("value", "The R Script")
 *                                 )),
 *                                 Map.entry("R Version", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", ""),
 *                                     Map.entry("value", "CRAN R 3.1.0")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("node2", Map.ofEntries(
 *                             Map.entry("assetId", "asset2"),
 *                             Map.entry("parameters", Map.ofEntries(
 *                                 Map.entry("Account Key", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", "TheThumbprint"),
 *                                     Map.entry("value", "Encrypted Key")
 *                                 )),
 *                                 Map.entry("Account Name", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", ""),
 *                                     Map.entry("value", "accountName")
 *                                 )),
 *                                 Map.entry("Please Specify Authentication Type", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", ""),
 *                                     Map.entry("value", "Account")
 *                                 )),
 *                                 Map.entry("Please Specify Data Source", Map.ofEntries(
 *                                     Map.entry("certificateThumbprint", ""),
 *                                     Map.entry("value", "AzureBlobStorage")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("node3", Map.of("inputId", "input1")),
 *                         Map.entry("node4", Map.of("outputId", "output1"))
 *                     ))
 *                     .build())
 *                 .packageType("Graph")
 *                 .parameters()
 *                 .payloadsInBlobStorage(false)
 *                 .readOnly(false)
 *                 .realtimeConfiguration(RealtimeConfigurationArgs.builder()
 *                     .maxConcurrentCalls(4)
 *                     .build())
 *                 .storageAccount(StorageAccountArgs.builder()
 *                     .key("Storage_Key")
 *                     .name("Storage_Name")
 *                     .build())
 *                 .title("Web Service Title")
 *                 .build())
 *             .resourceGroupName("OneResourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .webServiceName("TargetWebServiceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearning:WebService myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/webServices/{webServiceName}
 * ```
 */
public class WebService internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearning.WebService,
) : KotlinCustomResource(javaResource, WebServiceMapper) {
    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Contains the property payload that describes the web service.
     */
    public val properties: Output<WebServicePropertiesForGraphResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebServiceMapper : ResourceMapper<WebService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearning.WebService::class == javaResource::class

    override fun map(javaResource: Resource): WebService = WebService(
        javaResource as
            com.pulumi.azurenative.machinelearning.WebService,
    )
}

/**
 * @see [WebService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebService].
 */
public suspend fun webService(name: String, block: suspend WebServiceResourceBuilder.() -> Unit):
    WebService {
    val builder = WebServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webService(name: String): WebService {
    val builder = WebServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
