@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.AssetItemArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.AssetType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Information about an asset associated with the web service.
 * @property id Asset's Id.
 * @property inputPorts Information about the asset's input ports.
 * @property locationInfo Access information for the asset.
 * @property metadata If the asset is a custom module, this holds the module's metadata.
 * @property name Asset's friendly name.
 * @property outputPorts Information about the asset's output ports.
 * @property parameters If the asset is a custom module, this holds the module's parameters.
 * @property type Asset's type.
 */
public data class AssetItemArgs(
    public val id: Output<String>? = null,
    public val inputPorts: Output<Map<String, InputPortArgs>>? = null,
    public val locationInfo: Output<BlobLocationArgs>,
    public val metadata: Output<Map<String, String>>? = null,
    public val name: Output<String>,
    public val outputPorts: Output<Map<String, OutputPortArgs>>? = null,
    public val parameters: Output<List<ModuleAssetParameterArgs>>? = null,
    public val type: Output<Either<String, AssetType>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.AssetItemArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.AssetItemArgs =
        com.pulumi.azurenative.machinelearning.inputs.AssetItemArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .inputPorts(
                inputPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .locationInfo(locationInfo.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .outputPorts(
                outputPorts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetItemArgs].
 */
@PulumiTagMarker
public class AssetItemArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var inputPorts: Output<Map<String, InputPortArgs>>? = null

    private var locationInfo: Output<BlobLocationArgs>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var outputPorts: Output<Map<String, OutputPortArgs>>? = null

    private var parameters: Output<List<ModuleAssetParameterArgs>>? = null

    private var type: Output<Either<String, AssetType>>? = null

    /**
     * @param value Asset's Id.
     */
    @JvmName("amcavhrevftdexbx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Information about the asset's input ports.
     */
    @JvmName("matnmaoncjblqdgg")
    public suspend fun inputPorts(`value`: Output<Map<String, InputPortArgs>>) {
        this.inputPorts = value
    }

    /**
     * @param value Access information for the asset.
     */
    @JvmName("obbniworuxigiajn")
    public suspend fun locationInfo(`value`: Output<BlobLocationArgs>) {
        this.locationInfo = value
    }

    /**
     * @param value If the asset is a custom module, this holds the module's metadata.
     */
    @JvmName("mvaxmxkjrsfinffh")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Asset's friendly name.
     */
    @JvmName("hwgcossjevjiophj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Information about the asset's output ports.
     */
    @JvmName("yvdejnbiuxsmwwpp")
    public suspend fun outputPorts(`value`: Output<Map<String, OutputPortArgs>>) {
        this.outputPorts = value
    }

    /**
     * @param value If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("sjpmuywhruvnimwy")
    public suspend fun parameters(`value`: Output<List<ModuleAssetParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("omtredhrnnadyjut")
    public suspend fun parameters(vararg values: Output<ModuleAssetParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("gvvpkuvjtuikbyjh")
    public suspend fun parameters(values: List<Output<ModuleAssetParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Asset's type.
     */
    @JvmName("usmqftsbfpqwgbcx")
    public suspend fun type(`value`: Output<Either<String, AssetType>>) {
        this.type = value
    }

    /**
     * @param value Asset's Id.
     */
    @JvmName("ccajnnxldnpptnbt")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Information about the asset's input ports.
     */
    @JvmName("wunqqjkwmhcovgnn")
    public suspend fun inputPorts(`value`: Map<String, InputPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputPorts = mapped
    }

    /**
     * @param argument Information about the asset's input ports.
     */
    @JvmName("llduxncfnwqteqqk")
    public suspend fun inputPorts(
        vararg
        argument: Pair<String, suspend InputPortArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                InputPortArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.inputPorts = mapped
    }

    /**
     * @param values Information about the asset's input ports.
     */
    @JvmName("iskrsbydykjwarwr")
    public fun inputPorts(vararg values: Pair<String, InputPortArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputPorts = mapped
    }

    /**
     * @param value Access information for the asset.
     */
    @JvmName("kmhbkjpoyvpwwnty")
    public suspend fun locationInfo(`value`: BlobLocationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param argument Access information for the asset.
     */
    @JvmName("thqpnliribtxvsxe")
    public suspend fun locationInfo(argument: suspend BlobLocationArgsBuilder.() -> Unit) {
        val toBeMapped = BlobLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param value If the asset is a custom module, this holds the module's metadata.
     */
    @JvmName("ajattyacektnbgat")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values If the asset is a custom module, this holds the module's metadata.
     */
    @JvmName("inokjtyjqpmxycsv")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Asset's friendly name.
     */
    @JvmName("dkeiedotxmgdaqha")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Information about the asset's output ports.
     */
    @JvmName("kiblugwvuqncscoh")
    public suspend fun outputPorts(`value`: Map<String, OutputPortArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputPorts = mapped
    }

    /**
     * @param argument Information about the asset's output ports.
     */
    @JvmName("etfuqrrlruxmepsm")
    public suspend fun outputPorts(
        vararg
        argument: Pair<String, suspend OutputPortArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                OutputPortArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.outputPorts = mapped
    }

    /**
     * @param values Information about the asset's output ports.
     */
    @JvmName("mgilkagvwkpoibkg")
    public fun outputPorts(vararg values: Pair<String, OutputPortArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputPorts = mapped
    }

    /**
     * @param value If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("xbydaephmeyuokcq")
    public suspend fun parameters(`value`: List<ModuleAssetParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("fdqkuuaofspgytod")
    public suspend
    fun parameters(argument: List<suspend ModuleAssetParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("hgltjscepudgywls")
    public suspend fun parameters(
        vararg
        argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("bpfmivtdqvpejcyh")
    public suspend fun parameters(argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModuleAssetParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values If the asset is a custom module, this holds the module's parameters.
     */
    @JvmName("ydjygilygcwdhcaw")
    public suspend fun parameters(vararg values: ModuleAssetParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Asset's type.
     */
    @JvmName("hwtgvuqofeodrsve")
    public suspend fun type(`value`: Either<String, AssetType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Asset's type.
     */
    @JvmName("kbaahgrfmbymqafb")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Asset's type.
     */
    @JvmName("qoranjemkfamwjdy")
    public fun type(`value`: AssetType) {
        val toBeMapped = Either.ofRight<String, AssetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AssetItemArgs = AssetItemArgs(
        id = id,
        inputPorts = inputPorts,
        locationInfo = locationInfo ?: throw PulumiNullFieldException("locationInfo"),
        metadata = metadata,
        name = name ?: throw PulumiNullFieldException("name"),
        outputPorts = outputPorts,
        parameters = parameters,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
