@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.GetCommitmentPlanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property commitmentPlanName The Azure ML commitment plan name.
 * @property resourceGroupName The resource group name.
 */
public data class GetCommitmentPlanPlainArgs(
    public val commitmentPlanName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.GetCommitmentPlanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.GetCommitmentPlanPlainArgs =
        com.pulumi.azurenative.machinelearning.inputs.GetCommitmentPlanPlainArgs.builder()
            .commitmentPlanName(commitmentPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommitmentPlanPlainArgs].
 */
@PulumiTagMarker
public class GetCommitmentPlanPlainArgsBuilder internal constructor() {
    private var commitmentPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Azure ML commitment plan name.
     */
    @JvmName("qwlkppjuikqkdiip")
    public suspend fun commitmentPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("lvvovsffojnrqint")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCommitmentPlanPlainArgs = GetCommitmentPlanPlainArgs(
        commitmentPlanName = commitmentPlanName ?: throw PulumiNullFieldException("commitmentPlanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
