@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Nested parameter definition.
 * @property interfaceString The interface string name for the nested parameter.
 * @property parameters The definition of the parameter.
 */
public data class ModeValueInfoArgs(
    public val interfaceString: Output<String>? = null,
    public val parameters: Output<List<ModuleAssetParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs =
        com.pulumi.azurenative.machinelearning.inputs.ModeValueInfoArgs.builder()
            .interfaceString(interfaceString?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ModeValueInfoArgs].
 */
@PulumiTagMarker
public class ModeValueInfoArgsBuilder internal constructor() {
    private var interfaceString: Output<String>? = null

    private var parameters: Output<List<ModuleAssetParameterArgs>>? = null

    /**
     * @param value The interface string name for the nested parameter.
     */
    @JvmName("opholljhhkvqavbc")
    public suspend fun interfaceString(`value`: Output<String>) {
        this.interfaceString = value
    }

    /**
     * @param value The definition of the parameter.
     */
    @JvmName("bpmmnlpgvjdecwsi")
    public suspend fun parameters(`value`: Output<List<ModuleAssetParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("mnjxpoyhajgvniqf")
    public suspend fun parameters(vararg values: Output<ModuleAssetParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values The definition of the parameter.
     */
    @JvmName("wrfhxyntkcobkqjh")
    public suspend fun parameters(values: List<Output<ModuleAssetParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value The interface string name for the nested parameter.
     */
    @JvmName("enrnxmlkpnskaljf")
    public suspend fun interfaceString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interfaceString = mapped
    }

    /**
     * @param value The definition of the parameter.
     */
    @JvmName("kybsixwppahfbxpj")
    public suspend fun parameters(`value`: List<ModuleAssetParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("lyeqpsvslwnmtmvb")
    public suspend
    fun parameters(argument: List<suspend ModuleAssetParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("bafnnojwxmcqoren")
    public suspend fun parameters(
        vararg
        argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ModuleAssetParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument The definition of the parameter.
     */
    @JvmName("hwngwaiohhwiwtpe")
    public suspend fun parameters(argument: suspend ModuleAssetParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ModuleAssetParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The definition of the parameter.
     */
    @JvmName("roryxkrmhaktkgqn")
    public suspend fun parameters(vararg values: ModuleAssetParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ModeValueInfoArgs = ModeValueInfoArgs(
        interfaceString = interfaceString,
        parameters = parameters,
    )
}
