@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.OutputPortArgs.builder
import com.pulumi.azurenative.machinelearning.kotlin.enums.OutputPortType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Asset output port
 * @property type Port data type.
 */
public data class OutputPortArgs(
    public val type: Output<Either<String, OutputPortType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.OutputPortArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearning.inputs.OutputPortArgs =
        com.pulumi.azurenative.machinelearning.inputs.OutputPortArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [OutputPortArgs].
 */
@PulumiTagMarker
public class OutputPortArgsBuilder internal constructor() {
    private var type: Output<Either<String, OutputPortType>>? = null

    /**
     * @param value Port data type.
     */
    @JvmName("wmrqiwnljovpeitg")
    public suspend fun type(`value`: Output<Either<String, OutputPortType>>) {
        this.type = value
    }

    /**
     * @param value Port data type.
     */
    @JvmName("kulkjokxkcxbjqbh")
    public suspend fun type(`value`: Either<String, OutputPortType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Port data type.
     */
    @JvmName("luecrsiemchywriw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputPortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Port data type.
     */
    @JvmName("rykdpashcciftlsm")
    public fun type(`value`: OutputPortType) {
        val toBeMapped = Either.ofRight<String, OutputPortType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OutputPortArgs = OutputPortArgs(
        type = type,
    )
}
