@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.inputs

import com.pulumi.azurenative.machinelearning.inputs.ServiceInputOutputSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The swagger 2.0 schema describing the service's inputs or outputs. See Swagger specification: http://swagger.io/specification/
 * @property description The description of the Swagger schema.
 * @property properties Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
 * @property title The title of your Swagger schema.
 * @property type The type of the entity described in swagger. Always 'object'.
 */
public data class ServiceInputOutputSpecificationArgs(
    public val description: Output<String>? = null,
    public val properties: Output<Map<String, TableSpecificationArgs>>,
    public val title: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearning.inputs.ServiceInputOutputSpecificationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearning.inputs.ServiceInputOutputSpecificationArgs =
        com.pulumi.azurenative.machinelearning.inputs.ServiceInputOutputSpecificationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .properties(
                properties.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .title(title?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceInputOutputSpecificationArgs].
 */
@PulumiTagMarker
public class ServiceInputOutputSpecificationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var properties: Output<Map<String, TableSpecificationArgs>>? = null

    private var title: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the Swagger schema.
     */
    @JvmName("tsjoxjqacbvbnkou")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
     */
    @JvmName("jpmwtovxscwwmudd")
    public suspend fun properties(`value`: Output<Map<String, TableSpecificationArgs>>) {
        this.properties = value
    }

    /**
     * @param value The title of your Swagger schema.
     */
    @JvmName("tjqbhmkhrtmnmmrg")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The type of the entity described in swagger. Always 'object'.
     */
    @JvmName("xoerijyohubmpsqs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the Swagger schema.
     */
    @JvmName("pwcsqtrequrkeqgn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
     */
    @JvmName("pyqifskdebwuargp")
    public suspend fun properties(`value`: Map<String, TableSpecificationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
     */
    @JvmName("cneoeprfibiwjncv")
    public suspend fun properties(
        vararg
        argument: Pair<String, suspend TableSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                TableSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param values Specifies a collection that contains the column schema for each input or output of the web service. For more information, see the Swagger specification.
     */
    @JvmName("yebxvxbbhlbasdjd")
    public fun properties(vararg values: Pair<String, TableSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The title of your Swagger schema.
     */
    @JvmName("ysgpqncruqgrxsfa")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    /**
     * @param value The type of the entity described in swagger. Always 'object'.
     */
    @JvmName("hfhdpgqfytrofefn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceInputOutputSpecificationArgs = ServiceInputOutputSpecificationArgs(
        description = description,
        properties = properties ?: throw PulumiNullFieldException("properties"),
        title = title,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
