@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties of an Azure ML commitment plan.
 * @property chargeForOverage Indicates whether usage beyond the commitment plan's included quantities will be charged.
 * @property chargeForPlan Indicates whether the commitment plan will incur a charge.
 * @property creationDate The date at which this commitment plan was created, in ISO 8601 format.
 * @property includedQuantities The included resource quantities this plan gives you.
 * @property maxAssociationLimit The maximum number of commitment associations that can be children of this commitment plan.
 * @property maxCapacityLimit The maximum scale-out capacity for this commitment plan.
 * @property minCapacityLimit The minimum scale-out capacity for this commitment plan.
 * @property planMeter The Azure meter which will be used to charge for this commitment plan.
 * @property refillFrequencyInDays The frequency at which this commitment plan's included quantities are refilled.
 * @property suspendPlanOnOverage Indicates whether this commitment plan will be moved into a suspended state if usage goes beyond the commitment plan's included quantities.
 */
public data class CommitmentPlanPropertiesResponse(
    public val chargeForOverage: Boolean,
    public val chargeForPlan: Boolean,
    public val creationDate: String,
    public val includedQuantities: Map<String, PlanQuantityResponse>,
    public val maxAssociationLimit: Int,
    public val maxCapacityLimit: Int,
    public val minCapacityLimit: Int,
    public val planMeter: String,
    public val refillFrequencyInDays: Int,
    public val suspendPlanOnOverage: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.CommitmentPlanPropertiesResponse):
            CommitmentPlanPropertiesResponse = CommitmentPlanPropertiesResponse(
            chargeForOverage = javaType.chargeForOverage(),
            chargeForPlan = javaType.chargeForPlan(),
            creationDate = javaType.creationDate(),
            includedQuantities = javaType.includedQuantities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.PlanQuantityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            maxAssociationLimit = javaType.maxAssociationLimit(),
            maxCapacityLimit = javaType.maxCapacityLimit(),
            minCapacityLimit = javaType.minCapacityLimit(),
            planMeter = javaType.planMeter(),
            refillFrequencyInDays = javaType.refillFrequencyInDays(),
            suspendPlanOnOverage = javaType.suspendPlanOnOverage(),
        )
    }
}
