@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearning.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The swagger 2.0 schema describing a single service input or output. See Swagger specification: http://swagger.io/specification/
 * @property description Swagger schema description.
 * @property format The format, if 'type' is not 'object'
 * @property properties The set of columns within the data table.
 * @property title Swagger schema title.
 * @property type The type of the entity described in swagger.
 */
public data class TableSpecificationResponse(
    public val description: String? = null,
    public val format: String? = null,
    public val properties: Map<String, ColumnSpecificationResponse>? = null,
    public val title: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearning.outputs.TableSpecificationResponse):
            TableSpecificationResponse = TableSpecificationResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            format = javaType.format().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.machinelearning.kotlin.outputs.ColumnSpecificationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            title = javaType.title().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
