@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin

import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AcsClusterPropertiesResponse
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AppInsightsPropertiesResponse
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ContainerRegistryPropertiesResponse
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ErrorResponseWrapperResponse
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.GlobalServiceConfigurationResponse
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.StorageAccountPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AcsClusterPropertiesResponse.Companion.toKotlin as acsClusterPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AppInsightsPropertiesResponse.Companion.toKotlin as appInsightsPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ContainerRegistryPropertiesResponse.Companion.toKotlin as containerRegistryPropertiesResponseToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ErrorResponseWrapperResponse.Companion.toKotlin as errorResponseWrapperResponseToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.GlobalServiceConfigurationResponse.Companion.toKotlin as globalServiceConfigurationResponseToKotlin
import com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.StorageAccountPropertiesResponse.Companion.toKotlin as storageAccountPropertiesResponseToKotlin

/**
 * Builder for [OperationalizationCluster].
 */
@PulumiTagMarker
public class OperationalizationClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OperationalizationClusterArgs = OperationalizationClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OperationalizationClusterArgsBuilder.() -> Unit) {
        val builder = OperationalizationClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OperationalizationCluster {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OperationalizationCluster(builtJavaResource)
    }
}

/**
 * Instance of an Azure ML Operationalization Cluster resource.
 * Azure REST API version: 2017-08-01-preview. Prior API version in Azure Native 1.x: 2017-08-01-preview.
 * Other available API versions: 2017-06-01-preview.
 * ## Example Usage
 * ### PUT Operationalization Cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var operationalizationCluster = new AzureNative.MachineLearningCompute.OperationalizationCluster("operationalizationCluster", new()
 *     {
 *         ClusterName = "myCluster",
 *         ClusterType = AzureNative.MachineLearningCompute.ClusterType.ACS,
 *         ContainerService = new AzureNative.MachineLearningCompute.Inputs.AcsClusterPropertiesArgs
 *         {
 *             OrchestratorProperties = new AzureNative.MachineLearningCompute.Inputs.KubernetesClusterPropertiesArgs
 *             {
 *                 ServicePrincipal = new AzureNative.MachineLearningCompute.Inputs.ServicePrincipalPropertiesArgs
 *                 {
 *                     ClientId = "abcdefghijklmnopqrt",
 *                     Secret = "<secret>",
 *                 },
 *             },
 *             OrchestratorType = AzureNative.MachineLearningCompute.OrchestratorType.Kubernetes,
 *         },
 *         Description = "My Operationalization Cluster",
 *         GlobalServiceConfiguration = new AzureNative.MachineLearningCompute.Inputs.GlobalServiceConfigurationArgs
 *         {
 *             Ssl = new AzureNative.MachineLearningCompute.Inputs.SslConfigurationArgs
 *             {
 *                 Cert = "afjdklq2131casfakld=",
 *                 Cname = "foo.bar.com",
 *                 Key = "flksdafkldsajf=",
 *                 Status = AzureNative.MachineLearningCompute.Status.Enabled,
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key1", "alpha" },
 *             { "key2", "beta" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningcompute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningcompute.NewOperationalizationCluster(ctx, "operationalizationCluster", &machinelearningcompute.OperationalizationClusterArgs{
 * 			ClusterName: pulumi.String("myCluster"),
 * 			ClusterType: pulumi.String(machinelearningcompute.ClusterTypeACS),
 * 			ContainerService: &machinelearningcompute.AcsClusterPropertiesArgs{
 * 				OrchestratorProperties: &machinelearningcompute.KubernetesClusterPropertiesArgs{
 * 					ServicePrincipal: &machinelearningcompute.ServicePrincipalPropertiesArgs{
 * 						ClientId: pulumi.String("abcdefghijklmnopqrt"),
 * 						Secret:   pulumi.String("<secret>"),
 * 					},
 * 				},
 * 				OrchestratorType: pulumi.String(machinelearningcompute.OrchestratorTypeKubernetes),
 * 			},
 * 			Description: pulumi.String("My Operationalization Cluster"),
 * 			GlobalServiceConfiguration: &machinelearningcompute.GlobalServiceConfigurationArgs{
 * 				Ssl: &machinelearningcompute.SslConfigurationArgs{
 * 					Cert:   pulumi.String("afjdklq2131casfakld="),
 * 					Cname:  pulumi.String("foo.bar.com"),
 * 					Key:    pulumi.String("flksdafkldsajf="),
 * 					Status: pulumi.String(machinelearningcompute.StatusEnabled),
 * 				},
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("alpha"),
 * 				"key2": pulumi.String("beta"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster;
 * import com.pulumi.azurenative.machinelearningcompute.OperationalizationClusterArgs;
 * import com.pulumi.azurenative.machinelearningcompute.inputs.AcsClusterPropertiesArgs;
 * import com.pulumi.azurenative.machinelearningcompute.inputs.KubernetesClusterPropertiesArgs;
 * import com.pulumi.azurenative.machinelearningcompute.inputs.ServicePrincipalPropertiesArgs;
 * import com.pulumi.azurenative.machinelearningcompute.inputs.GlobalServiceConfigurationArgs;
 * import com.pulumi.azurenative.machinelearningcompute.inputs.SslConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operationalizationCluster = new OperationalizationCluster("operationalizationCluster", OperationalizationClusterArgs.builder()
 *             .clusterName("myCluster")
 *             .clusterType("ACS")
 *             .containerService(AcsClusterPropertiesArgs.builder()
 *                 .orchestratorProperties(KubernetesClusterPropertiesArgs.builder()
 *                     .servicePrincipal(ServicePrincipalPropertiesArgs.builder()
 *                         .clientId("abcdefghijklmnopqrt")
 *                         .secret("<secret>")
 *                         .build())
 *                     .build())
 *                 .orchestratorType("Kubernetes")
 *                 .build())
 *             .description("My Operationalization Cluster")
 *             .globalServiceConfiguration(GlobalServiceConfigurationArgs.builder()
 *                 .ssl(SslConfigurationArgs.builder()
 *                     .cert("afjdklq2131casfakld=")
 *                     .cname("foo.bar.com")
 *                     .key("flksdafkldsajf=")
 *                     .status("Enabled")
 *                     .build())
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "alpha"),
 *                 Map.entry("key2", "beta")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningcompute:OperationalizationCluster MyCluster /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningCompute/operationalizationClusters/{clusterName}
 * ```
 */
public class OperationalizationCluster internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster,
) : KotlinCustomResource(javaResource, OperationalizationClusterMapper) {
    /**
     * AppInsights configuration.
     */
    public val appInsights: Output<AppInsightsPropertiesResponse>?
        get() = javaResource.appInsights().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    appInsightsPropertiesResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The cluster type.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * Container Registry properties.
     */
    public val containerRegistry: Output<ContainerRegistryPropertiesResponse>?
        get() = javaResource.containerRegistry().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerRegistryPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Parameters for the Azure Container Service cluster.
     */
    public val containerService: Output<AcsClusterPropertiesResponse>?
        get() = javaResource.containerService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> acsClusterPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The date and time when the cluster was created.
     */
    public val createdOn: Output<String>
        get() = javaResource.createdOn().applyValue({ args0 -> args0 })

    /**
     * The description of the cluster.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Contains global configuration for the web services in the cluster.
     */
    public val globalServiceConfiguration: Output<GlobalServiceConfigurationResponse>?
        get() = javaResource.globalServiceConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> globalServiceConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The date and time when the cluster was last modified.
     */
    public val modifiedOn: Output<String>
        get() = javaResource.modifiedOn().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of provisioning errors reported by the resource provider.
     */
    public val provisioningErrors: Output<List<ErrorResponseWrapperResponse>>
        get() = javaResource.provisioningErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> errorResponseWrapperResponseToKotlin(args0) })
            })
        })

    /**
     * The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Storage Account properties.
     */
    public val storageAccount: Output<StorageAccountPropertiesResponse>?
        get() = javaResource.storageAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageAccountPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OperationalizationClusterMapper : ResourceMapper<OperationalizationCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster::class == javaResource::class

    override fun map(javaResource: Resource): OperationalizationCluster =
        OperationalizationCluster(
            javaResource as
                com.pulumi.azurenative.machinelearningcompute.OperationalizationCluster,
        )
}

/**
 * @see [OperationalizationCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OperationalizationCluster].
 */
public suspend fun operationalizationCluster(
    name: String,
    block: suspend OperationalizationClusterResourceBuilder.() -> Unit,
): OperationalizationCluster {
    val builder = OperationalizationClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OperationalizationCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun operationalizationCluster(name: String): OperationalizationCluster {
    val builder = OperationalizationClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
