@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.ServiceAuthConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Global service auth configuration properties. These are the data-plane authorization keys and are used if a service doesn't define it's own.
 * @property primaryAuthKeyHash The primary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
 * @property secondaryAuthKeyHash The secondary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
 */
public data class ServiceAuthConfigurationArgs(
    public val primaryAuthKeyHash: Output<String>,
    public val secondaryAuthKeyHash: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.ServiceAuthConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.ServiceAuthConfigurationArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.ServiceAuthConfigurationArgs.builder()
            .primaryAuthKeyHash(primaryAuthKeyHash.applyValue({ args0 -> args0 }))
            .secondaryAuthKeyHash(secondaryAuthKeyHash.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceAuthConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceAuthConfigurationArgsBuilder internal constructor() {
    private var primaryAuthKeyHash: Output<String>? = null

    private var secondaryAuthKeyHash: Output<String>? = null

    /**
     * @param value The primary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
     */
    @JvmName("lvphsljlalkfdvnd")
    public suspend fun primaryAuthKeyHash(`value`: Output<String>) {
        this.primaryAuthKeyHash = value
    }

    /**
     * @param value The secondary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
     */
    @JvmName("hwxhwbarmiqdnocb")
    public suspend fun secondaryAuthKeyHash(`value`: Output<String>) {
        this.secondaryAuthKeyHash = value
    }

    /**
     * @param value The primary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
     */
    @JvmName("epgdgkmsevbxqqcl")
    public suspend fun primaryAuthKeyHash(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryAuthKeyHash = mapped
    }

    /**
     * @param value The secondary auth key hash. This is not returned in response of GET/PUT on the resource.. To see this please call listKeys API.
     */
    @JvmName("dmxdhgnuxxsawugu")
    public suspend fun secondaryAuthKeyHash(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryAuthKeyHash = mapped
    }

    internal fun build(): ServiceAuthConfigurationArgs = ServiceAuthConfigurationArgs(
        primaryAuthKeyHash = primaryAuthKeyHash ?: throw PulumiNullFieldException("primaryAuthKeyHash"),
        secondaryAuthKeyHash = secondaryAuthKeyHash ?: throw
            PulumiNullFieldException("secondaryAuthKeyHash"),
    )
}
