@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.SslConfigurationArgs.builder
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SSL configuration. If configured data-plane calls to user services will be exposed over SSL only.
 * @property cert The SSL cert data in PEM format.
 * @property cname The CName of the certificate.
 * @property key The SSL key data in PEM format. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API.
 * @property status SSL status. Allowed values are Enabled and Disabled.
 */
public data class SslConfigurationArgs(
    public val cert: Output<String>? = null,
    public val cname: Output<String>? = null,
    public val key: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.SslConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningcompute.inputs.SslConfigurationArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.SslConfigurationArgs.builder()
            .cert(cert?.applyValue({ args0 -> args0 }))
            .cname(cname?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SslConfigurationArgs].
 */
@PulumiTagMarker
public class SslConfigurationArgsBuilder internal constructor() {
    private var cert: Output<String>? = null

    private var cname: Output<String>? = null

    private var key: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    /**
     * @param value The SSL cert data in PEM format.
     */
    @JvmName("tsfkfpnaxphgnnfj")
    public suspend fun cert(`value`: Output<String>) {
        this.cert = value
    }

    /**
     * @param value The CName of the certificate.
     */
    @JvmName("stnwlxsfvuueyvai")
    public suspend fun cname(`value`: Output<String>) {
        this.cname = value
    }

    /**
     * @param value The SSL key data in PEM format. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API.
     */
    @JvmName("njuktstfvmbmdpfk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value SSL status. Allowed values are Enabled and Disabled.
     */
    @JvmName("akgnyjmwsoodnbxi")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value The SSL cert data in PEM format.
     */
    @JvmName("rkhlkbbllfygkdgv")
    public suspend fun cert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cert = mapped
    }

    /**
     * @param value The CName of the certificate.
     */
    @JvmName("slbrsqolwdeyucdc")
    public suspend fun cname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cname = mapped
    }

    /**
     * @param value The SSL key data in PEM format. This is not returned in response of GET/PUT on the resource. To see this please call listKeys API.
     */
    @JvmName("aqytuwrkcnixiefv")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value SSL status. Allowed values are Enabled and Disabled.
     */
    @JvmName("njwmoqpahbwqfarx")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value SSL status. Allowed values are Enabled and Disabled.
     */
    @JvmName("jccjemqmscxqfcfs")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value SSL status. Allowed values are Enabled and Disabled.
     */
    @JvmName("jayrpaecaxppudql")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): SslConfigurationArgs = SslConfigurationArgs(
        cert = cert,
        cname = cname,
        key = key,
        status = status,
    )
}
