@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.SystemServiceArgs.builder
import com.pulumi.azurenative.machinelearningcompute.kotlin.enums.SystemServiceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about a system service deployed in the cluster
 * @property systemServiceType The system service type
 */
public data class SystemServiceArgs(
    public val systemServiceType: Output<Either<String, SystemServiceType>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.SystemServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningcompute.inputs.SystemServiceArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.SystemServiceArgs.builder()
            .systemServiceType(
                systemServiceType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SystemServiceArgs].
 */
@PulumiTagMarker
public class SystemServiceArgsBuilder internal constructor() {
    private var systemServiceType: Output<Either<String, SystemServiceType>>? = null

    /**
     * @param value The system service type
     */
    @JvmName("vtvdbnexscbipthr")
    public suspend fun systemServiceType(`value`: Output<Either<String, SystemServiceType>>) {
        this.systemServiceType = value
    }

    /**
     * @param value The system service type
     */
    @JvmName("effbuqglqjdxkmjm")
    public suspend fun systemServiceType(`value`: Either<String, SystemServiceType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemServiceType = mapped
    }

    /**
     * @param value The system service type
     */
    @JvmName("bpnlvswwjegpactj")
    public fun systemServiceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SystemServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemServiceType = mapped
    }

    /**
     * @param value The system service type
     */
    @JvmName("pgaunnbfdhqfgtpt")
    public fun systemServiceType(`value`: SystemServiceType) {
        val toBeMapped = Either.ofRight<String, SystemServiceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemServiceType = mapped
    }

    internal fun build(): SystemServiceArgs = SystemServiceArgs(
        systemServiceType = systemServiceType ?: throw PulumiNullFieldException("systemServiceType"),
    )
}
