@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.CodeContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Code Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var codeContainer = new AzureNative.MachineLearningServices.CodeContainer("codeContainer", new()
 *     {
 *         CodeContainerProperties = new AzureNative.MachineLearningServices.Inputs.CodeContainerArgs
 *         {
 *             Description = "string",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         Name = "testContainer",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCodeContainer(ctx, "codeContainer", &machinelearningservices.CodeContainerArgs{
 * 			CodeContainerProperties: &machinelearningservices.CodeContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("testContainer"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.CodeContainer;
 * import com.pulumi.azurenative.machinelearningservices.CodeContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.CodeContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var codeContainer = new CodeContainer("codeContainer", CodeContainerArgs.builder()
 *             .codeContainerProperties(CodeContainerArgs.builder()
 *                 .description("string")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .name("testContainer")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:CodeContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/codes/{name}
 * ```
 * @property codeContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class CodeContainerArgs(
    public val codeContainerProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.CodeContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.CodeContainerArgs =
        com.pulumi.azurenative.machinelearningservices.CodeContainerArgs.builder()
            .codeContainerProperties(
                codeContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CodeContainerArgs].
 */
@PulumiTagMarker
public class CodeContainerArgsBuilder internal constructor() {
    private var codeContainerProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("hptpafjfrviigrfs")
    public suspend
    fun codeContainerProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgs>) {
        this.codeContainerProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("axifaaxuasgsqwos")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ihkespyddakegeys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ptqjpufwfolqtjda")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("pbntjjayyerrgbsv")
    public suspend
    fun codeContainerProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("mkvsneplalbixulh")
    public suspend
    fun codeContainerProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.codeContainerProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("puapcgqppcuqbbbd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kuolbwbedkhyuvwv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("fviqurilfmvokpur")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): CodeContainerArgs = CodeContainerArgs(
        codeContainerProperties = codeContainerProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
