@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.DataContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Data Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataContainer = new AzureNative.MachineLearningServices.DataContainer("dataContainer", new()
 *     {
 *         DataContainerProperties = new AzureNative.MachineLearningServices.Inputs.DataContainerArgs
 *         {
 *             DataType = "UriFile",
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "properties1", "value1" },
 *                 { "properties2", "value2" },
 *             },
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         Name = "datacontainer123",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspace123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDataContainer(ctx, "dataContainer", &machinelearningservices.DataContainerArgs{
 * 			DataContainerProperties: &machinelearningservices.DataContainerTypeArgs{
 * 				DataType:    pulumi.String("UriFile"),
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"properties1": pulumi.String("value1"),
 * 					"properties2": pulumi.String("value2"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("datacontainer123"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspace123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.DataContainer;
 * import com.pulumi.azurenative.machinelearningservices.DataContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.DataContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataContainer = new DataContainer("dataContainer", DataContainerArgs.builder()
 *             .dataContainerProperties(DataContainerArgs.builder()
 *                 .dataType("UriFile")
 *                 .description("string")
 *                 .properties(Map.ofEntries(
 *                     Map.entry("properties1", "value1"),
 *                     Map.entry("properties2", "value2")
 *                 ))
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .name("datacontainer123")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspace123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:DataContainer datacontainer123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/data/{name}
 * ```
 * @property dataContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class DataContainerArgs(
    public val dataContainerProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.DataContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.DataContainerArgs =
        com.pulumi.azurenative.machinelearningservices.DataContainerArgs.builder()
            .dataContainerProperties(
                dataContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataContainerArgs].
 */
@PulumiTagMarker
public class DataContainerArgsBuilder internal constructor() {
    private var dataContainerProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("wmfotipcpxkwdbmu")
    public suspend
    fun dataContainerProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgs>) {
        this.dataContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("bifepgwjotxxwvlt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("shnksearuriolbqk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("qkngheqkuirwyshk")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("wwflebhwfxgdyhnd")
    public suspend
    fun dataContainerProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("hvbqsfvxhiaxxmrt")
    public suspend
    fun dataContainerProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dataContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("dpbmrbilutsrwtih")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("olndtwkbcaynftrg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("hdxbwulasijknmvc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DataContainerArgs = DataContainerArgs(
        dataContainerProperties = dataContainerProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
