@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EndpointDeployment].
 */
@PulumiTagMarker
public class EndpointDeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointDeploymentArgs = EndpointDeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointDeploymentArgsBuilder.() -> Unit) {
        val builder = EndpointDeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EndpointDeployment {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.EndpointDeployment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EndpointDeployment(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2024-01-01-preview.
 * ## Example Usage
 * ### Create Endpoint Deployment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpointDeployment = new AzureNative.MachineLearningServices.EndpointDeployment("endpointDeployment", new()
 *     {
 *         DeploymentName = "text-davinci-003",
 *         EndpointName = "Azure.OpenAI",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.OpenAIEndpointDeploymentResourcePropertiesArgs
 *         {
 *             Model = new AzureNative.MachineLearningServices.Inputs.EndpointDeploymentModelArgs
 *             {
 *                 Format = "OpenAI",
 *                 Name = "text-davinci-003",
 *                 Version = "1",
 *             },
 *             Type = "Azure.OpenAI",
 *             VersionUpgradeOption = AzureNative.MachineLearningServices.DeploymentModelVersionUpgradeOption.OnceNewDefaultVersionAvailable,
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEndpointDeployment(ctx, "endpointDeployment", &machinelearningservices.EndpointDeploymentArgs{
 * 			DeploymentName: pulumi.String("text-davinci-003"),
 * 			EndpointName:   pulumi.String("Azure.OpenAI"),
 * 			Properties: machinelearningservices.OpenAIEndpointDeploymentResourceProperties{
 * 				Model: machinelearningservices.EndpointDeploymentModel{
 * 					Format:  "OpenAI",
 * 					Name:    "text-davinci-003",
 * 					Version: "1",
 * 				},
 * 				Type:                 "Azure.OpenAI",
 * 				VersionUpgradeOption: machinelearningservices.DeploymentModelVersionUpgradeOptionOnceNewDefaultVersionAvailable,
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EndpointDeployment;
 * import com.pulumi.azurenative.machinelearningservices.EndpointDeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpointDeployment = new EndpointDeployment("endpointDeployment", EndpointDeploymentArgs.builder()
 *             .deploymentName("text-davinci-003")
 *             .endpointName("Azure.OpenAI")
 *             .properties(ContentSafetyEndpointDeploymentResourcePropertiesArgs.builder()
 *                 .model(EndpointDeploymentModelArgs.builder()
 *                     .format("OpenAI")
 *                     .name("text-davinci-003")
 *                     .version("1")
 *                     .build())
 *                 .type("Azure.OpenAI")
 *                 .versionUpgradeOption("OnceNewDefaultVersionAvailable")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EndpointDeployment text-davinci-003 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/endpoints/{endpointName}/deployments/{deploymentName}
 * ```
 */
public class EndpointDeployment internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.EndpointDeployment,
) : KotlinCustomResource(javaResource, EndpointDeploymentMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EndpointDeploymentMapper : ResourceMapper<EndpointDeployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.EndpointDeployment::class == javaResource::class

    override fun map(javaResource: Resource): EndpointDeployment = EndpointDeployment(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.EndpointDeployment,
    )
}

/**
 * @see [EndpointDeployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EndpointDeployment].
 */
public suspend fun endpointDeployment(
    name: String,
    block: suspend EndpointDeploymentResourceBuilder.() -> Unit,
): EndpointDeployment {
    val builder = EndpointDeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EndpointDeployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpointDeployment(name: String): EndpointDeployment {
    val builder = EndpointDeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
