@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2021-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Environment Specification Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentSpecificationVersion = new AzureNative.MachineLearningServices.EnvironmentSpecificationVersion("environmentSpecificationVersion", new()
 *     {
 *         Name = "testEnvironment",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.EnvironmentSpecificationVersionArgs
 *         {
 *             CondaFile = @"channels:
 * - defaults
 * dependencies:
 * - python=3.7.7
 * name: my-env",
 *             Description = "string",
 *             Docker = new AzureNative.MachineLearningServices.Inputs.DockerBuildArgs
 *             {
 *                 DockerSpecificationType = "Build",
 *                 Dockerfile = "FROM myimage",
 *             },
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         Version = "1",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEnvironmentSpecificationVersion(ctx, "environmentSpecificationVersion", &machinelearningservices.EnvironmentSpecificationVersionArgs{
 * 			Name: pulumi.String("testEnvironment"),
 * 			Properties: &machinelearningservices.EnvironmentSpecificationVersionTypeArgs{
 * 				CondaFile:   pulumi.String("channels:\n- defaults\ndependencies:\n- python=3.7.7\nname: my-env"),
 * 				Description: pulumi.String("string"),
 * 				Docker: machinelearningservices.DockerBuild{
 * 					DockerSpecificationType: "Build",
 * 					Dockerfile:              "FROM myimage",
 * 				},
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Version:           pulumi.String("1"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentSpecificationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentSpecificationVersion = new EnvironmentSpecificationVersion("environmentSpecificationVersion", EnvironmentSpecificationVersionArgs.builder()
 *             .name("testEnvironment")
 *             .properties(EnvironmentSpecificationVersionArgs.builder()
 *                 .condaFile("""
 * channels:
 * - defaults
 * dependencies:
 * - python=3.7.7
 * name: my-env                """)
 *                 .description("string")
 *                 .docker(DockerBuildArgs.builder()
 *                     .dockerSpecificationType("Build")
 *                     .dockerfile("FROM myimage")
 *                     .build())
 *                 .properties(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .tags(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .build())
 *             .resourceGroupName("testrg123")
 *             .version("1")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EnvironmentSpecificationVersion 1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/environments/{name}/versions/{version}
 * ```
 * @property name Name of EnvironmentSpecificationVersion.
 * @property properties [Required] Additional attributes of the entity.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version of EnvironmentSpecificationVersion.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class EnvironmentSpecificationVersionArgs(
    public val name: Output<String>? = null,
    public val properties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs =
        com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentSpecificationVersionArgs].
 */
@PulumiTagMarker
public class EnvironmentSpecificationVersionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Name of EnvironmentSpecificationVersion.
     */
    @JvmName("funcsjyqyspiwxnu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("htluyfpkxxltnkih")
    public suspend
    fun properties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eeeplflcolhhfikb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version of EnvironmentSpecificationVersion.
     */
    @JvmName("lvocbmjpsqtgatxj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("rxkhqhxohmlmlglr")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Name of EnvironmentSpecificationVersion.
     */
    @JvmName("xknhkchlynudbmsv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("qyaclfbknfpwsapo")
    public suspend
    fun properties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("mgmwjvtvrgwdxcfn")
    public suspend
    fun properties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentSpecificationVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oiktoykbyevvfekk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version of EnvironmentSpecificationVersion.
     */
    @JvmName("xtavbeowrstglubg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("wrkqfibveajymxos")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EnvironmentSpecificationVersionArgs = EnvironmentSpecificationVersionArgs(
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
