@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.FeaturestoreEntityContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Featurestore Entity Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var featurestoreEntityContainerEntity = new AzureNative.MachineLearningServices.FeaturestoreEntityContainerEntity("featurestoreEntityContainerEntity", new()
 *     {
 *         FeaturestoreEntityContainerProperties = new AzureNative.MachineLearningServices.Inputs.FeaturestoreEntityContainerArgs
 *         {
 *             Description = "string",
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewFeaturestoreEntityContainerEntity(ctx, "featurestoreEntityContainerEntity", &machinelearningservices.FeaturestoreEntityContainerEntityArgs{
 * 			FeaturestoreEntityContainerProperties: &machinelearningservices.FeaturestoreEntityContainerArgs{
 * 				Description: pulumi.String("string"),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntity;
 * import com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.FeaturestoreEntityContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var featurestoreEntityContainerEntity = new FeaturestoreEntityContainerEntity("featurestoreEntityContainerEntity", FeaturestoreEntityContainerEntityArgs.builder()
 *             .featurestoreEntityContainerProperties(FeaturestoreEntityContainerArgs.builder()
 *                 .description("string")
 *                 .isArchived(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:FeaturestoreEntityContainerEntity string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/featurestoreEntities/{name}
 * ```
 * @property featurestoreEntityContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class FeaturestoreEntityContainerEntityArgs(
    public val featurestoreEntityContainerProperties: Output<FeaturestoreEntityContainerArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs =
        com.pulumi.azurenative.machinelearningservices.FeaturestoreEntityContainerEntityArgs.builder()
            .featurestoreEntityContainerProperties(
                featurestoreEntityContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeaturestoreEntityContainerEntityArgs].
 */
@PulumiTagMarker
public class FeaturestoreEntityContainerEntityArgsBuilder internal constructor() {
    private var featurestoreEntityContainerProperties: Output<FeaturestoreEntityContainerArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("lmweikxkntpyltng")
    public suspend
    fun featurestoreEntityContainerProperties(`value`: Output<FeaturestoreEntityContainerArgs>) {
        this.featurestoreEntityContainerProperties = value
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("qdegghhvaatyiaem")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iunjgmgwwiiqqfje")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("jrtvsmswuxqkxhlc")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("qexnkddvtlpvvsua")
    public suspend
    fun featurestoreEntityContainerProperties(`value`: FeaturestoreEntityContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featurestoreEntityContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("bvgjkaubxjgjwrpq")
    public suspend
    fun featurestoreEntityContainerProperties(argument: suspend FeaturestoreEntityContainerArgsBuilder.() -> Unit) {
        val toBeMapped = FeaturestoreEntityContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.featurestoreEntityContainerProperties = mapped
    }

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("bvywivfspbylyvkh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("colamtnbennfarim")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ghihvprogvbtosfg")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): FeaturestoreEntityContainerEntityArgs =
        FeaturestoreEntityContainerEntityArgs(
            featurestoreEntityContainerProperties = featurestoreEntityContainerProperties,
            name = name,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
}
