@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.JobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate AutoML Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.AutoMLJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             EnvironmentId = "string",
 *             EnvironmentVariables =
 *             {
 *                 { "string", "string" },
 *             },
 *             ExperimentName = "string",
 *             Identity = new AzureNative.MachineLearningServices.Inputs.AmlTokenArgs
 *             {
 *                 IdentityType = "AMLToken",
 *             },
 *             IsArchived = false,
 *             JobType = "AutoML",
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = AzureNative.MachineLearningServices.OutputDeliveryMode.ReadWriteMount,
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *             {
 *                 InstanceCount = 1,
 *                 InstanceType = "string",
 *                 Properties =
 *                 {
 *                     { "string",
 *                     {
 *                         { "9bec0ab0-c62f-4fa9-a97c-7b24bbcc90ad", null },
 *                     } },
 *                 },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             TaskDetails = new AzureNative.MachineLearningServices.Inputs.ImageClassificationArgs
 *             {
 *                 LimitSettings = new AzureNative.MachineLearningServices.Inputs.ImageLimitSettingsArgs
 *                 {
 *                     MaxTrials = 2,
 *                 },
 *                 ModelSettings = new AzureNative.MachineLearningServices.Inputs.ImageModelSettingsClassificationArgs
 *                 {
 *                     ValidationCropSize = 2,
 *                 },
 *                 SearchSpace = new[]
 *                 {
 *                     new AzureNative.MachineLearningServices.Inputs.ImageModelDistributionSettingsClassificationArgs
 *                     {
 *                         ValidationCropSize = "choice(2, 360)",
 *                     },
 *                 },
 *                 TargetColumnName = "string",
 *                 TaskType = "ImageClassification",
 *                 TrainingData = new AzureNative.MachineLearningServices.Inputs.MLTableJobInputArgs
 *                 {
 *                     JobInputType = "mltable",
 *                     Uri = "string",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.AutoMLJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * ExperimentName: "string",
 * Identity: machinelearningservices.AmlToken{
 * IdentityType: "AMLToken",
 * },
 * IsArchived: false,
 * JobType: "AutoML",
 * Outputs: map[string]interface{}{
 * "string": machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: machinelearningservices.OutputDeliveryModeReadWriteMount,
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "9bec0ab0-c62f-4fa9-a97c-7b24bbcc90ad": nil,
 * },
 * },
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * TaskDetails: machinelearningservices.ImageClassification{
 * LimitSettings: machinelearningservices.ImageLimitSettings{
 * MaxTrials: 2,
 * },
 * ModelSettings: machinelearningservices.ImageModelSettingsClassification{
 * ValidationCropSize: 2,
 * },
 * SearchSpace: []machinelearningservices.ImageModelDistributionSettingsClassification{
 * {
 * ValidationCropSize: "choice(2, 360)",
 * },
 * },
 * TargetColumnName: "string",
 * TaskType: "ImageClassification",
 * TrainingData: machinelearningservices.MLTableJobInput{
 * JobInputType: "mltable",
 * Uri: "string",
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(AutoMLJobArgs.builder()
 *                 .computeId("string")
 *                 .description("string")
 *                 .displayName("string")
 *                 .environmentId("string")
 *                 .environmentVariables(Map.of("string", "string"))
 *                 .experimentName("string")
 *                 .identity(AmlTokenArgs.builder()
 *                     .identityType("AMLToken")
 *                     .build())
 *                 .isArchived(false)
 *                 .jobType("AutoML")
 *                 .outputs(Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "ReadWriteMount"),
 *                     Map.entry("uri", "string")
 *                 )))
 *                 .properties(Map.of("string", "string"))
 *                 .resources(JobResourceConfigurationArgs.builder()
 *                     .instanceCount(1)
 *                     .instanceType("string")
 *                     .properties(Map.of("string", Map.of("9bec0ab0-c62f-4fa9-a97c-7b24bbcc90ad", null)))
 *                     .build())
 *                 .services(Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", Map.of("string", "string"))
 *                 )))
 *                 .tags(Map.of("string", "string"))
 *                 .taskDetails(ImageClassificationArgs.builder()
 *                     .limitSettings(ImageLimitSettingsArgs.builder()
 *                         .maxTrials(2)
 *                         .build())
 *                     .modelSettings(ImageModelSettingsClassificationArgs.builder()
 *                         .validationCropSize(2)
 *                         .build())
 *                     .searchSpace(ImageModelDistributionSettingsClassificationArgs.builder()
 *                         .validationCropSize("choice(2, 360)")
 *                         .build())
 *                     .targetColumnName("string")
 *                     .taskType("ImageClassification")
 *                     .trainingData(MLTableJobInputArgs.builder()
 *                         .jobInputType("mltable")
 *                         .uri("string")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Command Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.CommandJobArgs
 *         {
 *             CodeId = "string",
 *             Command = "string",
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             Distribution = new AzureNative.MachineLearningServices.Inputs.TensorFlowArgs
 *             {
 *                 DistributionType = "TensorFlow",
 *                 ParameterServerCount = 1,
 *                 WorkerCount = 1,
 *             },
 *             EnvironmentId = "string",
 *             EnvironmentVariables =
 *             {
 *                 { "string", "string" },
 *             },
 *             ExperimentName = "string",
 *             Identity = new AzureNative.MachineLearningServices.Inputs.AmlTokenArgs
 *             {
 *                 IdentityType = "AMLToken",
 *             },
 *             Inputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.LiteralJobInputArgs
 *                 {
 *                     Description = "string",
 *                     JobInputType = "literal",
 *                     Value = "string",
 *                 } },
 *             },
 *             JobType = "Command",
 *             Limits = new AzureNative.MachineLearningServices.Inputs.CommandJobLimitsArgs
 *             {
 *                 JobLimitsType = "Command",
 *                 Timeout = "PT5M",
 *             },
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = AzureNative.MachineLearningServices.OutputDeliveryMode.ReadWriteMount,
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *             {
 *                 InstanceCount = 1,
 *                 InstanceType = "string",
 *                 Properties =
 *                 {
 *                     { "string",
 *                     {
 *                         { "e6b6493e-7d5e-4db3-be1e-306ec641327e", null },
 *                     } },
 *                 },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.CommandJob{
 * CodeId: "string",
 * Command: "string",
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * Distribution: machinelearningservices.TensorFlow{
 * DistributionType: "TensorFlow",
 * ParameterServerCount: 1,
 * WorkerCount: 1,
 * },
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * ExperimentName: "string",
 * Identity: machinelearningservices.AmlToken{
 * IdentityType: "AMLToken",
 * },
 * Inputs: map[string]interface{}{
 * "string": machinelearningservices.LiteralJobInput{
 * Description: "string",
 * JobInputType: "literal",
 * Value: "string",
 * },
 * },
 * JobType: "Command",
 * Limits: machinelearningservices.CommandJobLimits{
 * JobLimitsType: "Command",
 * Timeout: "PT5M",
 * },
 * Outputs: map[string]interface{}{
 * "string": machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: machinelearningservices.OutputDeliveryModeReadWriteMount,
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "e6b6493e-7d5e-4db3-be1e-306ec641327e": nil,
 * },
 * },
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(CommandJobArgs.builder()
 *                 .codeId("string")
 *                 .command("string")
 *                 .computeId("string")
 *                 .description("string")
 *                 .displayName("string")
 *                 .distribution(TensorFlowArgs.builder()
 *                     .distributionType("TensorFlow")
 *                     .parameterServerCount(1)
 *                     .workerCount(1)
 *                     .build())
 *                 .environmentId("string")
 *                 .environmentVariables(Map.of("string", "string"))
 *                 .experimentName("string")
 *                 .identity(AmlTokenArgs.builder()
 *                     .identityType("AMLToken")
 *                     .build())
 *                 .inputs(Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobInputType", "literal"),
 *                     Map.entry("value", "string")
 *                 )))
 *                 .jobType("Command")
 *                 .limits(CommandJobLimitsArgs.builder()
 *                     .jobLimitsType("Command")
 *                     .timeout("PT5M")
 *                     .build())
 *                 .outputs(Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "ReadWriteMount"),
 *                     Map.entry("uri", "string")
 *                 )))
 *                 .properties(Map.of("string", "string"))
 *                 .resources(JobResourceConfigurationArgs.builder()
 *                     .instanceCount(1)
 *                     .instanceType("string")
 *                     .properties(Map.of("string", Map.of("e6b6493e-7d5e-4db3-be1e-306ec641327e", null)))
 *                     .build())
 *                 .services(Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", Map.of("string", "string"))
 *                 )))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Pipeline Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.PipelineJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             ExperimentName = "string",
 *             Inputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.LiteralJobInputArgs
 *                 {
 *                     Description = "string",
 *                     JobInputType = "literal",
 *                     Value = "string",
 *                 } },
 *             },
 *             JobType = "Pipeline",
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = AzureNative.MachineLearningServices.OutputDeliveryMode.Upload,
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Settings = null,
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.PipelineJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * ExperimentName: "string",
 * Inputs: map[string]interface{}{
 * "string": machinelearningservices.LiteralJobInput{
 * Description: "string",
 * JobInputType: "literal",
 * Value: "string",
 * },
 * },
 * JobType: "Pipeline",
 * Outputs: map[string]interface{}{
 * "string": machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: machinelearningservices.OutputDeliveryModeUpload,
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Settings: nil,
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(PipelineJobArgs.builder()
 *                 .computeId("string")
 *                 .description("string")
 *                 .displayName("string")
 *                 .experimentName("string")
 *                 .inputs(Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobInputType", "literal"),
 *                     Map.entry("value", "string")
 *                 )))
 *                 .jobType("Pipeline")
 *                 .outputs(Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "Upload"),
 *                     Map.entry("uri", "string")
 *                 )))
 *                 .properties(Map.of("string", "string"))
 *                 .services(Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", Map.of("string", "string"))
 *                 )))
 *                 .settings()
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Sweep Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.SweepJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             EarlyTermination = new AzureNative.MachineLearningServices.Inputs.MedianStoppingPolicyArgs
 *             {
 *                 DelayEvaluation = 1,
 *                 EvaluationInterval = 1,
 *                 PolicyType = "MedianStopping",
 *             },
 *             ExperimentName = "string",
 *             JobType = "Sweep",
 *             Limits = new AzureNative.MachineLearningServices.Inputs.SweepJobLimitsArgs
 *             {
 *                 JobLimitsType = "Sweep",
 *                 MaxConcurrentTrials = 1,
 *                 MaxTotalTrials = 1,
 *                 TrialTimeout = "PT1S",
 *             },
 *             Objective = new AzureNative.MachineLearningServices.Inputs.ObjectiveArgs
 *             {
 *                 Goal = AzureNative.MachineLearningServices.Goal.Minimize,
 *                 PrimaryMetric = "string",
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             SamplingAlgorithm = new AzureNative.MachineLearningServices.Inputs.GridSamplingAlgorithmArgs
 *             {
 *                 SamplingAlgorithmType = "Grid",
 *             },
 *             SearchSpace =
 *             {
 *                 { "string", null },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             Trial = new AzureNative.MachineLearningServices.Inputs.TrialComponentArgs
 *             {
 *                 CodeId = "string",
 *                 Command = "string",
 *                 Distribution = new AzureNative.MachineLearningServices.Inputs.MpiArgs
 *                 {
 *                     DistributionType = "Mpi",
 *                     ProcessCountPerInstance = 1,
 *                 },
 *                 EnvironmentId = "string",
 *                 EnvironmentVariables =
 *                 {
 *                     { "string", "string" },
 *                 },
 *                 Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     InstanceType = "string",
 *                     Properties =
 *                     {
 *                         { "string",
 *                         {
 *                             { "e6b6493e-7d5e-4db3-be1e-306ec641327e", null },
 *                         } },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.SweepJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * EarlyTermination: machinelearningservices.MedianStoppingPolicy{
 * DelayEvaluation: 1,
 * EvaluationInterval: 1,
 * PolicyType: "MedianStopping",
 * },
 * ExperimentName: "string",
 * JobType: "Sweep",
 * Limits: machinelearningservices.SweepJobLimits{
 * JobLimitsType: "Sweep",
 * MaxConcurrentTrials: 1,
 * MaxTotalTrials: 1,
 * TrialTimeout: "PT1S",
 * },
 * Objective: machinelearningservices.Objective{
 * Goal: machinelearningservices.GoalMinimize,
 * PrimaryMetric: "string",
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * SamplingAlgorithm: machinelearningservices.GridSamplingAlgorithm{
 * SamplingAlgorithmType: "Grid",
 * },
 * SearchSpace: map[string]interface{}{
 * "string": nil,
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * Trial: machinelearningservices.TrialComponent{
 * CodeId: "string",
 * Command: "string",
 * Distribution: machinelearningservices.Mpi{
 * DistributionType: "Mpi",
 * ProcessCountPerInstance: 1,
 * },
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "e6b6493e-7d5e-4db3-be1e-306ec641327e": nil,
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(SweepJobArgs.builder()
 *                 .computeId("string")
 *                 .description("string")
 *                 .displayName("string")
 *                 .earlyTermination(MedianStoppingPolicyArgs.builder()
 *                     .delayEvaluation(1)
 *                     .evaluationInterval(1)
 *                     .policyType("MedianStopping")
 *                     .build())
 *                 .experimentName("string")
 *                 .jobType("Sweep")
 *                 .limits(SweepJobLimitsArgs.builder()
 *                     .jobLimitsType("Sweep")
 *                     .maxConcurrentTrials(1)
 *                     .maxTotalTrials(1)
 *                     .trialTimeout("PT1S")
 *                     .build())
 *                 .objective(ObjectiveArgs.builder()
 *                     .goal("Minimize")
 *                     .primaryMetric("string")
 *                     .build())
 *                 .properties(Map.of("string", "string"))
 *                 .samplingAlgorithm(GridSamplingAlgorithmArgs.builder()
 *                     .samplingAlgorithmType("Grid")
 *                     .build())
 *                 .searchSpace(Map.of("string", ))
 *                 .services(Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", Map.of("string", "string"))
 *                 )))
 *                 .tags(Map.of("string", "string"))
 *                 .trial(TrialComponentArgs.builder()
 *                     .codeId("string")
 *                     .command("string")
 *                     .distribution(MpiArgs.builder()
 *                         .distributionType("Mpi")
 *                         .processCountPerInstance(1)
 *                         .build())
 *                     .environmentId("string")
 *                     .environmentVariables(Map.of("string", "string"))
 *                     .resources(JobResourceConfigurationArgs.builder()
 *                         .instanceCount(1)
 *                         .instanceType("string")
 *                         .properties(Map.of("string", Map.of("e6b6493e-7d5e-4db3-be1e-306ec641327e", null)))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Job string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/jobs/{id}
 * ```
 * @property id The name and identifier for the Job. This is case-sensitive.
 * @property jobBaseProperties [Required] Additional attributes of the entity.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class JobArgs(
    public val id: Output<String>? = null,
    public val jobBaseProperties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.JobArgs =
        com.pulumi.azurenative.machinelearningservices.JobArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .jobBaseProperties(jobBaseProperties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var jobBaseProperties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name and identifier for the Job. This is case-sensitive.
     */
    @JvmName("lfrmyoiilqbophvn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("efwlsuybgclmqppq")
    public suspend fun jobBaseProperties(`value`: Output<Any>) {
        this.jobBaseProperties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sltmvkcuqovoecqu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("fyweqgfwqhpnwfcq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name and identifier for the Job. This is case-sensitive.
     */
    @JvmName("fqapveeynnsqiwjs")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("afupxcqwhfhxoqgs")
    public suspend fun jobBaseProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobBaseProperties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mmofgwhyhrymlmaw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("smepmxbsaxbpuuie")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        id = id,
        jobBaseProperties = jobBaseProperties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
