@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingJobResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.LabelingJobResponse.Companion.toKotlin as labelingJobResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [LabelingJob].
 */
@PulumiTagMarker
public class LabelingJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LabelingJobArgs = LabelingJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LabelingJobArgsBuilder.() -> Unit) {
        val builder = LabelingJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LabelingJob {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.LabelingJob(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LabelingJob(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * Other available API versions: 2020-09-01-preview, 2021-03-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Labeling Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var labelingJob = new AzureNative.MachineLearningServices.LabelingJob("labelingJob", new()
 *     {
 *         Id = "testLabelingJob",
 *         LabelingJobProperties = new AzureNative.MachineLearningServices.Inputs.LabelingJobArgs
 *         {
 *             Description = "string",
 *             JobInstructions = new AzureNative.MachineLearningServices.Inputs.LabelingJobInstructionsArgs
 *             {
 *                 Uri = "link/to/instructions",
 *             },
 *             JobType = "Labeling",
 *             LabelCategories =
 *             {
 *                 { "myCategory1", new AzureNative.MachineLearningServices.Inputs.LabelCategoryArgs
 *                 {
 *                     Classes =
 *                     {
 *                         { "myLabelClass1", new AzureNative.MachineLearningServices.Inputs.LabelClassArgs
 *                         {
 *                             DisplayName = "myLabelClass1",
 *                             Subclasses = null,
 *                         } },
 *                         { "myLabelClass2", new AzureNative.MachineLearningServices.Inputs.LabelClassArgs
 *                         {
 *                             DisplayName = "myLabelClass2",
 *                             Subclasses = null,
 *                         } },
 *                     },
 *                     DisplayName = "myCategory1Title",
 *                     MultiSelect = AzureNative.MachineLearningServices.MultiSelect.Disabled,
 *                 } },
 *                 { "myCategory2", new AzureNative.MachineLearningServices.Inputs.LabelCategoryArgs
 *                 {
 *                     Classes =
 *                     {
 *                         { "myLabelClass1", new AzureNative.MachineLearningServices.Inputs.LabelClassArgs
 *                         {
 *                             DisplayName = "myLabelClass1",
 *                             Subclasses = null,
 *                         } },
 *                         { "myLabelClass2", new AzureNative.MachineLearningServices.Inputs.LabelClassArgs
 *                         {
 *                             DisplayName = "myLabelClass2",
 *                             Subclasses = null,
 *                         } },
 *                     },
 *                     DisplayName = "myCategory2Title",
 *                     MultiSelect = AzureNative.MachineLearningServices.MultiSelect.Disabled,
 *                 } },
 *             },
 *             LabelingJobMediaProperties = new AzureNative.MachineLearningServices.Inputs.LabelingJobImagePropertiesArgs
 *             {
 *                 MediaType = "Image",
 *             },
 *             MlAssistConfiguration = new AzureNative.MachineLearningServices.Inputs.MLAssistConfigurationEnabledArgs
 *             {
 *                 InferencingComputeBinding = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/myscoringcompute",
 *                 MlAssist = "Enabled",
 *                 TrainingComputeBinding = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/mytrainingompute",
 *             },
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         ResourceGroupName = "workspace-1234",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewLabelingJob(ctx, "labelingJob", &machinelearningservices.LabelingJobArgs{
 * Id: pulumi.String("testLabelingJob"),
 * LabelingJobProperties: &machinelearningservices.LabelingJobTypeArgs{
 * Description: pulumi.String("string"),
 * JobInstructions: &machinelearningservices.LabelingJobInstructionsArgs{
 * Uri: pulumi.String("link/to/instructions"),
 * },
 * JobType: pulumi.String("Labeling"),
 * LabelCategories: machinelearningservices.LabelCategoryMap{
 * "myCategory1": interface{}{
 * Classes: interface{}{
 * MyLabelClass1: &machinelearningservices.LabelClassArgs{
 * DisplayName: pulumi.String("myLabelClass1"),
 * Subclasses: nil,
 * },
 * MyLabelClass2: interface{}{
 * DisplayName: pulumi.String("myLabelClass2"),
 * Subclasses: nil,
 * },
 * },
 * DisplayName: pulumi.String("myCategory1Title"),
 * MultiSelect: pulumi.String(machinelearningservices.MultiSelectDisabled),
 * },
 * "myCategory2": interface{}{
 * Classes: machinelearningservices.LabelClassMap{
 * "myLabelClass1": &machinelearningservices.LabelClassArgs{
 * DisplayName: pulumi.String("myLabelClass1"),
 * Subclasses: nil,
 * },
 * "myLabelClass2": interface{}{
 * DisplayName: pulumi.String("myLabelClass2"),
 * Subclasses: nil,
 * },
 * },
 * DisplayName: pulumi.String("myCategory2Title"),
 * MultiSelect: pulumi.String(machinelearningservices.MultiSelectDisabled),
 * },
 * },
 * LabelingJobMediaProperties: machinelearningservices.LabelingJobImageProperties{
 * MediaType: "Image",
 * },
 * MlAssistConfiguration: machinelearningservices.MLAssistConfigurationEnabled{
 * InferencingComputeBinding: "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/myscoringcompute",
 * MlAssist: "Enabled",
 * TrainingComputeBinding: "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/mytrainingompute",
 * },
 * Properties: pulumi.StringMap{
 * "additionalProp1": pulumi.String("string"),
 * "additionalProp2": pulumi.String("string"),
 * "additionalProp3": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "additionalProp1": pulumi.String("string"),
 * "additionalProp2": pulumi.String("string"),
 * "additionalProp3": pulumi.String("string"),
 * },
 * },
 * ResourceGroupName: pulumi.String("workspace-1234"),
 * WorkspaceName: pulumi.String("testworkspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.LabelingJob;
 * import com.pulumi.azurenative.machinelearningservices.LabelingJobArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobInstructionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var labelingJob = new LabelingJob("labelingJob", LabelingJobArgs.builder()
 *             .id("testLabelingJob")
 *             .labelingJobProperties(LabelingJobArgs.builder()
 *                 .description("string")
 *                 .jobInstructions(LabelingJobInstructionsArgs.builder()
 *                     .uri("link/to/instructions")
 *                     .build())
 *                 .jobType("Labeling")
 *                 .labelCategories(Map.ofEntries(
 *                     Map.entry("myCategory1", Map.ofEntries(
 *                         Map.entry("classes", Map.ofEntries(
 *                             Map.entry("myLabelClass1", Map.ofEntries(
 *                                 Map.entry("displayName", "myLabelClass1"),
 *                                 Map.entry("subclasses", )
 *                             )),
 *                             Map.entry("myLabelClass2", Map.ofEntries(
 *                                 Map.entry("displayName", "myLabelClass2"),
 *                                 Map.entry("subclasses", )
 *                             ))
 *                         )),
 *                         Map.entry("displayName", "myCategory1Title"),
 *                         Map.entry("multiSelect", "Disabled")
 *                     )),
 *                     Map.entry("myCategory2", Map.ofEntries(
 *                         Map.entry("classes", Map.ofEntries(
 *                             Map.entry("myLabelClass1", Map.ofEntries(
 *                                 Map.entry("displayName", "myLabelClass1"),
 *                                 Map.entry("subclasses", )
 *                             )),
 *                             Map.entry("myLabelClass2", Map.ofEntries(
 *                                 Map.entry("displayName", "myLabelClass2"),
 *                                 Map.entry("subclasses", )
 *                             ))
 *                         )),
 *                         Map.entry("displayName", "myCategory2Title"),
 *                         Map.entry("multiSelect", "Disabled")
 *                     ))
 *                 ))
 *                 .labelingJobMediaProperties(LabelingJobImagePropertiesArgs.builder()
 *                     .mediaType("Image")
 *                     .build())
 *                 .mlAssistConfiguration(MLAssistConfigurationEnabledArgs.builder()
 *                     .inferencingComputeBinding("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/myscoringcompute")
 *                     .mlAssist("Enabled")
 *                     .trainingComputeBinding("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1234/providers/Microsoft.MachineLearningServices/workspaces/testworkspace/computes/mytrainingompute")
 *                     .build())
 *                 .properties(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .tags(Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *                 .build())
 *             .resourceGroupName("workspace-1234")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:LabelingJob testLabelingJob /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/labelingJobs/{id}
 * ```
 */
public class LabelingJob internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.LabelingJob,
) : KotlinCustomResource(javaResource, LabelingJobMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val labelingJobProperties: Output<LabelingJobResponse>
        get() = javaResource.labelingJobProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                labelingJobResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LabelingJobMapper : ResourceMapper<LabelingJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.LabelingJob::class == javaResource::class

    override fun map(javaResource: Resource): LabelingJob = LabelingJob(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.LabelingJob,
    )
}

/**
 * @see [LabelingJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LabelingJob].
 */
public suspend fun labelingJob(name: String, block: suspend LabelingJobResourceBuilder.() -> Unit):
    LabelingJob {
    val builder = LabelingJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LabelingJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun labelingJob(name: String): LabelingJob {
    val builder = LabelingJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
