@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.LinkedServicePropsArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.LinkedServicePropsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Linked service.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * ## Example Usage
 * ### CreateLinkedService
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedService = new AzureNative.MachineLearningServices.LinkedService("linkedService", new()
 *     {
 *         Identity = new AzureNative.MachineLearningServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.MachineLearningServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         LinkName = "link-1",
 *         Location = "westus",
 *         Name = "link-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.LinkedServicePropsArgs
 *         {
 *             LinkedServiceResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewLinkedService(ctx, "linkedService", &machinelearningservices.LinkedServiceArgs{
 * 			Identity: &machinelearningservices.IdentityArgs{
 * 				Type: machinelearningservices.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			LinkName: pulumi.String("link-1"),
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("link-1"),
 * 			Properties: &machinelearningservices.LinkedServicePropsArgs{
 * 				LinkedServiceResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.LinkedService;
 * import com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.IdentityArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.LinkedServicePropsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedService = new LinkedService("linkedService", LinkedServiceArgs.builder()
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .linkName("link-1")
 *             .location("westus")
 *             .name("link-1")
 *             .properties(LinkedServicePropsArgs.builder()
 *                 .linkedServiceResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/resourceGroup-1/providers/Microsoft.Synapse/workspaces/Syn-1")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:LinkedService link-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/linkedServices/{linkName}
 * ```
 * @property identity Identity for the resource.
 * @property linkName Friendly name of the linked workspace
 * @property location location of the linked service.
 * @property name Friendly name of the linked service
 * @property properties LinkedService specific properties.
 * @property resourceGroupName Name of the resource group in which workspace is located.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class LinkedServiceArgs(
    public val identity: Output<IdentityArgs>? = null,
    public val linkName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<LinkedServicePropsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs =
        com.pulumi.azurenative.machinelearningservices.LinkedServiceArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkName(linkName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkedServiceArgs].
 */
@PulumiTagMarker
public class LinkedServiceArgsBuilder internal constructor() {
    private var identity: Output<IdentityArgs>? = null

    private var linkName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<LinkedServicePropsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Identity for the resource.
     */
    @JvmName("ipprhhapilwftphp")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("xbejdhqmmcgyoihg")
    public suspend fun linkName(`value`: Output<String>) {
        this.linkName = value
    }

    /**
     * @param value location of the linked service.
     */
    @JvmName("tqanrrjaibsbtlsd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Friendly name of the linked service
     */
    @JvmName("emeppndnyurkuwvl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value LinkedService specific properties.
     */
    @JvmName("flhmpxnmmegrpqww")
    public suspend fun properties(`value`: Output<LinkedServicePropsArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("sdvahyhgydxjddpc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("dgsfcsopgbmmiykf")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("ojdoyqtupsykaeep")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("jedrcipaiyvqdbcf")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Friendly name of the linked workspace
     */
    @JvmName("fpamvurcjmyrqkla")
    public suspend fun linkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkName = mapped
    }

    /**
     * @param value location of the linked service.
     */
    @JvmName("okjpxdktoliqpokh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Friendly name of the linked service
     */
    @JvmName("uyglvkmndxhjkpjy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value LinkedService specific properties.
     */
    @JvmName("jdbcvgujgigmloby")
    public suspend fun properties(`value`: LinkedServicePropsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument LinkedService specific properties.
     */
    @JvmName("gmxhyvyxfnfppvqk")
    public suspend fun properties(argument: suspend LinkedServicePropsArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServicePropsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the resource group in which workspace is located.
     */
    @JvmName("fyfjkqhravlfbqqx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("dokvryxvgvdqrgkl")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): LinkedServiceArgs = LinkedServiceArgs(
        identity = identity,
        linkName = linkName,
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
