@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelContainerResponse.Companion.toKotlin as modelContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ModelContainer].
 */
@PulumiTagMarker
public class ModelContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelContainerArgs = ModelContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelContainerArgsBuilder.() -> Unit) {
        val builder = ModelContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ModelContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ModelContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ModelContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Model Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modelContainer = new AzureNative.MachineLearningServices.ModelContainer("modelContainer", new()
 *     {
 *         ModelContainerProperties = new AzureNative.MachineLearningServices.Inputs.ModelContainerArgs
 *         {
 *             Description = "Model container description",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         Name = "testContainer",
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspace123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewModelContainer(ctx, "modelContainer", &machinelearningservices.ModelContainerArgs{
 * 			ModelContainerProperties: &machinelearningservices.ModelContainerTypeArgs{
 * 				Description: pulumi.String("Model container description"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("testContainer"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspace123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ModelContainer;
 * import com.pulumi.azurenative.machinelearningservices.ModelContainerArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.ModelContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modelContainer = new ModelContainer("modelContainer", ModelContainerArgs.builder()
 *             .modelContainerProperties(ModelContainerArgs.builder()
 *                 .description("Model container description")
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *                 .build())
 *             .name("testContainer")
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspace123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ModelContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/models/{name}
 * ```
 */
public class ModelContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ModelContainer,
) : KotlinCustomResource(javaResource, ModelContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val modelContainerProperties: Output<ModelContainerResponse>
        get() = javaResource.modelContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                modelContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ModelContainerMapper : ResourceMapper<ModelContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ModelContainer::class == javaResource::class

    override fun map(javaResource: Resource): ModelContainer = ModelContainer(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.ModelContainer,
    )
}

/**
 * @see [ModelContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ModelContainer].
 */
public suspend fun modelContainer(
    name: String,
    block: suspend ModelContainerResourceBuilder.() -> Unit,
): ModelContainer {
    val builder = ModelContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ModelContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modelContainer(name: String): ModelContainer {
    val builder = ModelContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
