@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ComponentVersionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Component Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryComponentVersion = new AzureNative.MachineLearningServices.RegistryComponentVersion("registryComponentVersion", new()
 *     {
 *         ComponentName = "string",
 *         ComponentVersionProperties = new AzureNative.MachineLearningServices.Inputs.ComponentVersionArgs
 *         {
 *             ComponentSpec = new Dictionary<string, object?>
 *             {
 *                 ["8ced901b-d826-477d-bfef-329da9672513"] = null,
 *             },
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryComponentVersion(ctx, "registryComponentVersion", &machinelearningservices.RegistryComponentVersionArgs{
 * 			ComponentName: pulumi.String("string"),
 * 			ComponentVersionProperties: &machinelearningservices.ComponentVersionTypeArgs{
 * 				ComponentSpec: pulumi.Any(map[string]interface{}{
 * 					"8ced901b-d826-477d-bfef-329da9672513": nil,
 * 				}),
 * 				Description: pulumi.String("string"),
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.ComponentVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryComponentVersion = new RegistryComponentVersion("registryComponentVersion", RegistryComponentVersionArgs.builder()
 *             .componentName("string")
 *             .componentVersionProperties(ComponentVersionArgs.builder()
 *                 .componentSpec(Map.of("8ced901b-d826-477d-bfef-329da9672513", null))
 *                 .description("string")
 *                 .isAnonymous(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryComponentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/components/{componentName}/versions/{version}
 * ```
 * @property componentName Container name.
 * @property componentVersionProperties [Required] Additional attributes of the entity.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class RegistryComponentVersionArgs(
    public val componentName: Output<String>? = null,
    public val componentVersionProperties: Output<ComponentVersionArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryComponentVersionArgs.builder()
            .componentName(componentName?.applyValue({ args0 -> args0 }))
            .componentVersionProperties(
                componentVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryComponentVersionArgs].
 */
@PulumiTagMarker
public class RegistryComponentVersionArgsBuilder internal constructor() {
    private var componentName: Output<String>? = null

    private var componentVersionProperties: Output<ComponentVersionArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Container name.
     */
    @JvmName("dsigawutvgciacys")
    public suspend fun componentName(`value`: Output<String>) {
        this.componentName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("iywfhavetlxlcyvo")
    public suspend fun componentVersionProperties(`value`: Output<ComponentVersionArgs>) {
        this.componentVersionProperties = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("qmystrtystimxvde")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ucjgjcbtuvoytgke")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("vlvmcobsajcnwqan")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("ddfyusfquoexverd")
    public suspend fun componentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("qmcfltouedtsapph")
    public suspend fun componentVersionProperties(`value`: ComponentVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("enpjdsueucbtakhn")
    public suspend
    fun componentVersionProperties(argument: suspend ComponentVersionArgsBuilder.() -> Unit) {
        val toBeMapped = ComponentVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.componentVersionProperties = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("sigluqxrakvlmnun")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("veqdmhyrlegrgqwk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("rhckeyhnuqtcjpfk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RegistryComponentVersionArgs = RegistryComponentVersionArgs(
        componentName = componentName,
        componentVersionProperties = componentVersionProperties,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
