@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentVersionResponse.Companion.toKotlin as environmentVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryEnvironmentVersion].
 */
@PulumiTagMarker
public class RegistryEnvironmentVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryEnvironmentVersionArgs = RegistryEnvironmentVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryEnvironmentVersionArgsBuilder.() -> Unit) {
        val builder = RegistryEnvironmentVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegistryEnvironmentVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryEnvironmentVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Registry Environment Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryEnvironmentVersion = new AzureNative.MachineLearningServices.RegistryEnvironmentVersion("registryEnvironmentVersion", new()
 *     {
 *         EnvironmentName = "string",
 *         EnvironmentVersionProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentVersionArgs
 *         {
 *             Build = new AzureNative.MachineLearningServices.Inputs.BuildContextArgs
 *             {
 *                 ContextUri = "https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/",
 *                 DockerfilePath = "prod/Dockerfile",
 *             },
 *             CondaFile = "string",
 *             Description = "string",
 *             Image = "docker.io/tensorflow/serving:latest",
 *             InferenceConfig = new AzureNative.MachineLearningServices.Inputs.InferenceContainerPropertiesArgs
 *             {
 *                 LivenessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ReadinessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ScoringRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *             },
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryEnvironmentVersion(ctx, "registryEnvironmentVersion", &machinelearningservices.RegistryEnvironmentVersionArgs{
 * 			EnvironmentName: pulumi.String("string"),
 * 			EnvironmentVersionProperties: &machinelearningservices.EnvironmentVersionTypeArgs{
 * 				Build: &machinelearningservices.BuildContextArgs{
 * 					ContextUri:     pulumi.String("https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/"),
 * 					DockerfilePath: pulumi.String("prod/Dockerfile"),
 * 				},
 * 				CondaFile:   pulumi.String("string"),
 * 				Description: pulumi.String("string"),
 * 				Image:       pulumi.String("docker.io/tensorflow/serving:latest"),
 * 				InferenceConfig: &machinelearningservices.InferenceContainerPropertiesArgs{
 * 					LivenessRoute: &machinelearningservices.RouteArgs{
 * 						Path: pulumi.String("string"),
 * 						Port: pulumi.Int(1),
 * 					},
 * 					ReadinessRoute: &machinelearningservices.RouteArgs{
 * 						Path: pulumi.String("string"),
 * 						Port: pulumi.Int(1),
 * 					},
 * 					ScoringRoute: &machinelearningservices.RouteArgs{
 * 						Path: pulumi.String("string"),
 * 						Port: pulumi.Int(1),
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.EnvironmentVersionArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.BuildContextArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.InferenceContainerPropertiesArgs;
 * import com.pulumi.azurenative.machinelearningservices.inputs.RouteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryEnvironmentVersion = new RegistryEnvironmentVersion("registryEnvironmentVersion", RegistryEnvironmentVersionArgs.builder()
 *             .environmentName("string")
 *             .environmentVersionProperties(EnvironmentVersionArgs.builder()
 *                 .build(BuildContextArgs.builder()
 *                     .contextUri("https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/")
 *                     .dockerfilePath("prod/Dockerfile")
 *                     .build())
 *                 .condaFile("string")
 *                 .description("string")
 *                 .image("docker.io/tensorflow/serving:latest")
 *                 .inferenceConfig(InferenceContainerPropertiesArgs.builder()
 *                     .livenessRoute(RouteArgs.builder()
 *                         .path("string")
 *                         .port(1)
 *                         .build())
 *                     .readinessRoute(RouteArgs.builder()
 *                         .path("string")
 *                         .port(1)
 *                         .build())
 *                     .scoringRoute(RouteArgs.builder()
 *                         .path("string")
 *                         .port(1)
 *                         .build())
 *                     .build())
 *                 .isAnonymous(false)
 *                 .properties(Map.of("string", "string"))
 *                 .tags(Map.of("string", "string"))
 *                 .build())
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryEnvironmentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}/versions/{version}
 * ```
 */
public class RegistryEnvironmentVersion internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion,
) : KotlinCustomResource(javaResource, RegistryEnvironmentVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val environmentVersionProperties: Output<EnvironmentVersionResponse>
        get() = javaResource.environmentVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryEnvironmentVersionMapper : ResourceMapper<RegistryEnvironmentVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion::class == javaResource::class

    override fun map(javaResource: Resource): RegistryEnvironmentVersion =
        RegistryEnvironmentVersion(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentVersion,
        )
}

/**
 * @see [RegistryEnvironmentVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryEnvironmentVersion].
 */
public suspend fun registryEnvironmentVersion(
    name: String,
    block: suspend RegistryEnvironmentVersionResourceBuilder.() -> Unit,
):
    RegistryEnvironmentVersion {
    val builder = RegistryEnvironmentVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryEnvironmentVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryEnvironmentVersion(name: String): RegistryEnvironmentVersion {
    val builder = RegistryEnvironmentVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
