@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceConnection].
 */
@PulumiTagMarker
public class WorkspaceConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceConnectionArgs = WorkspaceConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceConnectionArgsBuilder.() -> Unit) {
        val builder = WorkspaceConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceConnection {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.WorkspaceConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceConnection(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2021-04-01, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01, 2024-01-01-preview.
 * ## Example Usage
 * ### CreateWorkspaceConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceConnection = new AzureNative.MachineLearningServices.WorkspaceConnection("workspaceConnection", new()
 *     {
 *         ConnectionName = "connection-1",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.NoneAuthTypeWorkspaceConnectionPropertiesArgs
 *         {
 *             AuthType = "None",
 *             Category = AzureNative.MachineLearningServices.ConnectionCategory.ContainerRegistry,
 *             Target = "www.facebook.com",
 *         },
 *         ResourceGroupName = "resourceGroup-1",
 *         WorkspaceName = "workspace-1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewWorkspaceConnection(ctx, "workspaceConnection", &machinelearningservices.WorkspaceConnectionArgs{
 * 			ConnectionName: pulumi.String("connection-1"),
 * 			Properties: machinelearningservices.NoneAuthTypeWorkspaceConnectionProperties{
 * 				AuthType: "None",
 * 				Category: machinelearningservices.ConnectionCategoryContainerRegistry,
 * 				Target:   "www.facebook.com",
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup-1"),
 * 			WorkspaceName:     pulumi.String("workspace-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.WorkspaceConnection;
 * import com.pulumi.azurenative.machinelearningservices.WorkspaceConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceConnection = new WorkspaceConnection("workspaceConnection", WorkspaceConnectionArgs.builder()
 *             .connectionName("connection-1")
 *             .properties(NoneAuthTypeWorkspaceConnectionPropertiesArgs.builder()
 *                 .authType("None")
 *                 .category("ContainerRegistry")
 *                 .target("www.facebook.com")
 *                 .build())
 *             .resourceGroupName("resourceGroup-1")
 *             .workspaceName("workspace-1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:WorkspaceConnection connection-1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/connections/{connectionName}
 * ```
 */
public class WorkspaceConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.WorkspaceConnection,
) : KotlinCustomResource(javaResource, WorkspaceConnectionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkspaceConnectionMapper : ResourceMapper<WorkspaceConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.WorkspaceConnection::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceConnection = WorkspaceConnection(
        javaResource
            as com.pulumi.azurenative.machinelearningservices.WorkspaceConnection,
    )
}

/**
 * @see [WorkspaceConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceConnection].
 */
public suspend fun workspaceConnection(
    name: String,
    block: suspend WorkspaceConnectionResourceBuilder.() -> Unit,
): WorkspaceConnection {
    val builder = WorkspaceConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceConnection(name: String): WorkspaceConnection {
    val builder = WorkspaceConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
