@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Primary metric to optimize for this task.
 */
public enum class ClassificationMultilabelPrimaryMetrics(
    public val javaValue:
    com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics> {
    /**
     * AUC is the Area under the curve.
     * This metric represents arithmetic mean of the score for each class,
     * weighted by the number of true instances in each class.
     */
    AUCWeighted(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.AUCWeighted),

    /**
     * Accuracy is the ratio of predictions that exactly match the true class labels.
     */
    Accuracy(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.Accuracy),

    /**
     * Normalized macro recall is recall macro-averaged and normalized, so that random
     * performance has a score of 0, and perfect performance has a score of 1.
     */
    NormMacroRecall(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.NormMacroRecall),

    /**
     * The arithmetic mean of the average precision score for each class, weighted by
     * the number of true instances in each class.
     */
    AveragePrecisionScoreWeighted(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.AveragePrecisionScoreWeighted),

    /**
     * The arithmetic mean of precision for each class, weighted by number of true instances in each class.
     */
    PrecisionScoreWeighted(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.PrecisionScoreWeighted),

    /**
     * Intersection Over Union. Intersection of predictions divided by union of predictions.
     */
    IOU(com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics.IOU),
    ;

    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ClassificationMultilabelPrimaryMetrics):
            ClassificationMultilabelPrimaryMetrics =
            ClassificationMultilabelPrimaryMetrics.values().first { it.javaValue == javaType }
    }
}
