@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
 */
public enum class EgressPublicNetworkAccessType(
    public val javaValue:
    com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType> {
    Enabled(com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType.Enabled),
    Disabled(com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType.Disabled),
    ;

    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.EgressPublicNetworkAccessType):
            EgressPublicNetworkAccessType =
            EgressPublicNetworkAccessType.values().first { it.javaValue == javaType }
    }
}
