@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the data in featurization phase.
 * If 'Off' is selected then no featurization is done.
 * If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
 */
public enum class FeaturizationMode(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode> {
    /**
     * Auto mode, system performs featurization without any custom featurization inputs.
     */
    Auto(com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode.Auto),

    /**
     * Custom featurization.
     */
    Custom(com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode.Custom),

    /**
     * Featurization off. 'Forecasting' task cannot use this value.
     */
    Off(com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode.Off),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.FeaturizationMode):
            FeaturizationMode = FeaturizationMode.values().first { it.javaValue == javaType }
    }
}
