@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
 */
public enum class LearningRateScheduler(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler> {
    /**
     * No learning rate scheduler selected.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler.None),

    /**
     * Cosine Annealing With Warmup.
     */
    WarmupCosine(com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler.WarmupCosine),

    /**
     * Step learning rate scheduler.
     */
    Step(com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler.Step),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.LearningRateScheduler):
            LearningRateScheduler = LearningRateScheduler.values().first { it.javaValue == javaType }
    }
}
