@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates which identity to use to authenticate service data access to customer's storage.
 */
public enum class ServiceDataAccessAuthIdentity(
    public val javaValue:
    com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity> {
    /**
     * Do not use any identity for service data access.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity.None),

    /**
     * Use the system assigned managed identity of the Workspace to authenticate service data access.
     */
    WorkspaceSystemAssignedIdentity(com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity.WorkspaceSystemAssignedIdentity),

    /**
     * Use the user assigned managed identity of the Workspace to authenticate service data access.
     */
    WorkspaceUserAssignedIdentity(com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity.WorkspaceUserAssignedIdentity),
    ;

    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity = javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.ServiceDataAccessAuthIdentity):
            ServiceDataAccessAuthIdentity =
            ServiceDataAccessAuthIdentity.values().first { it.javaValue == javaType }
    }
}
