@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
 */
public enum class SkuTier(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.SkuTier,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.SkuTier> {
    Free(com.pulumi.azurenative.machinelearningservices.enums.SkuTier.Free),
    Basic(com.pulumi.azurenative.machinelearningservices.enums.SkuTier.Basic),
    Standard(com.pulumi.azurenative.machinelearningservices.enums.SkuTier.Standard),
    Premium(com.pulumi.azurenative.machinelearningservices.enums.SkuTier.Premium),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.SkuTier = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.SkuTier):
            SkuTier = SkuTier.values().first { it.javaValue == javaType }
    }
}
