@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AksNetworkingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Advance configuration for AKS networking
 * @property dnsServiceIP An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
 * @property dockerBridgeCidr A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
 * @property serviceCidr A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
 * @property subnetId Virtual network subnet resource ID the compute nodes belong to
 */
public data class AksNetworkingConfigurationArgs(
    public val dnsServiceIP: Output<String>? = null,
    public val dockerBridgeCidr: Output<String>? = null,
    public val serviceCidr: Output<String>? = null,
    public val subnetId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AksNetworkingConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AksNetworkingConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AksNetworkingConfigurationArgs.builder()
            .dnsServiceIP(dnsServiceIP?.applyValue({ args0 -> args0 }))
            .dockerBridgeCidr(dockerBridgeCidr?.applyValue({ args0 -> args0 }))
            .serviceCidr(serviceCidr?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AksNetworkingConfigurationArgs].
 */
@PulumiTagMarker
public class AksNetworkingConfigurationArgsBuilder internal constructor() {
    private var dnsServiceIP: Output<String>? = null

    private var dockerBridgeCidr: Output<String>? = null

    private var serviceCidr: Output<String>? = null

    private var subnetId: Output<String>? = null

    /**
     * @param value An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("mgxuvpaxogolbfnx")
    public suspend fun dnsServiceIP(`value`: Output<String>) {
        this.dnsServiceIP = value
    }

    /**
     * @param value A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
     */
    @JvmName("ovoixucixiwryksj")
    public suspend fun dockerBridgeCidr(`value`: Output<String>) {
        this.dockerBridgeCidr = value
    }

    /**
     * @param value A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("bvxbjmysexuimfqo")
    public suspend fun serviceCidr(`value`: Output<String>) {
        this.serviceCidr = value
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to
     */
    @JvmName("subscrfintdpruyl")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified in serviceCidr.
     */
    @JvmName("gbpmwcmaaykksxyw")
    public suspend fun dnsServiceIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServiceIP = mapped
    }

    /**
     * @param value A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes service address range.
     */
    @JvmName("lgqkkjolstyilhxe")
    public suspend fun dockerBridgeCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerBridgeCidr = mapped
    }

    /**
     * @param value A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
     */
    @JvmName("ahhnxsdfbkiukwrb")
    public suspend fun serviceCidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceCidr = mapped
    }

    /**
     * @param value Virtual network subnet resource ID the compute nodes belong to
     */
    @JvmName("ymieeouqnyrioyee")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    internal fun build(): AksNetworkingConfigurationArgs = AksNetworkingConfigurationArgs(
        dnsServiceIP = dnsServiceIP,
        dockerBridgeCidr = dockerBridgeCidr,
        serviceCidr = serviceCidr,
        subnetId = subnetId,
    )
}
