@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoNCrossValidationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * N-Cross validations determined automatically.
 * @property mode Determines how N-Cross validations value is determined.
 * Expected value is 'Auto'.
 */
public data class AutoNCrossValidationsArgs(
    public val mode: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoNCrossValidationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AutoNCrossValidationsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoNCrossValidationsArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoNCrossValidationsArgs].
 */
@PulumiTagMarker
public class AutoNCrossValidationsArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Determines how N-Cross validations value is determined.
     * Expected value is 'Auto'.
     */
    @JvmName("mjrymneroqvbsjdq")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Determines how N-Cross validations value is determined.
     * Expected value is 'Auto'.
     */
    @JvmName("ioebxojrrvplvopa")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AutoNCrossValidationsArgs = AutoNCrossValidationsArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
