@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetLagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Target lags selection modes.
 * Expected value is 'Auto'.
 */
public data class AutoTargetLagsArgs(
    public val mode: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetLagsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetLagsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoTargetLagsArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoTargetLagsArgs].
 */
@PulumiTagMarker
public class AutoTargetLagsArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    /**
     * @param value Target lags selection modes.
     * Expected value is 'Auto'.
     */
    @JvmName("kliqwkvjtmcefopt")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Target lags selection modes.
     * Expected value is 'Auto'.
     */
    @JvmName("mjnsmwstddakrjvd")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): AutoTargetLagsArgs = AutoTargetLagsArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
    )
}
