@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen2DatastoreArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ServiceDataAccessAuthIdentity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Data Lake Gen2 datastore configuration.
 * @property accountName [Required] Storage account name.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureDataLakeGen2'.
 * @property description The asset description text.
 * @property endpoint Azure cloud endpoint for the storage account.
 * @property filesystem [Required] The name of the Data Lake Gen2 filesystem.
 * @property properties The asset property dictionary.
 * @property protocol Protocol used to communicate with the storage account.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureDataLakeGen2DatastoreArgs(
    public val accountName: Output<String>,
    public val credentials: Output<Any>,
    public val datastoreType: Output<String>,
    public val description: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val filesystem: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
    public val protocol: Output<String>? = null,
    public val serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen2DatastoreArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen2DatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen2DatastoreArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .credentials(credentials.applyValue({ args0 -> args0 }))
            .datastoreType(datastoreType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .filesystem(filesystem.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .serviceDataAccessAuthIdentity(
                serviceDataAccessAuthIdentity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureDataLakeGen2DatastoreArgs].
 */
@PulumiTagMarker
public class AzureDataLakeGen2DatastoreArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var credentials: Output<Any>? = null

    private var datastoreType: Output<String>? = null

    private var description: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var filesystem: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var protocol: Output<String>? = null

    private var serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Storage account name.
     */
    @JvmName("xporfasmlppbakrg")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("xbtaggaupsrgkkur")
    public suspend fun credentials(`value`: Output<Any>) {
        this.credentials = value
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureDataLakeGen2'.
     */
    @JvmName("lubcajqdrjrqyvtn")
    public suspend fun datastoreType(`value`: Output<String>) {
        this.datastoreType = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("nnkopsscxrkdkcda")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("ylxgxasprlkojrso")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value [Required] The name of the Data Lake Gen2 filesystem.
     */
    @JvmName("dpmdcomdbidhxrcy")
    public suspend fun filesystem(`value`: Output<String>) {
        this.filesystem = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("meavvdxaoncacmty")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("jxeluxfbjwqxhylb")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("qdpbltftoxelmxhb")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Output<Either<String, ServiceDataAccessAuthIdentity>>) {
        this.serviceDataAccessAuthIdentity = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("yxsfamkhsiwtqapl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Storage account name.
     */
    @JvmName("jrkslfcqiffnbyqb")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("rerdgtbpkwbjgois")
    public suspend fun credentials(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureDataLakeGen2'.
     */
    @JvmName("jtqmsbovxnpmhmfw")
    public suspend fun datastoreType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("eaxumbjbdhphxtue")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("edkhglwjmqxtcnao")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value [Required] The name of the Data Lake Gen2 filesystem.
     */
    @JvmName("cvvyugxlxthnxogq")
    public suspend fun filesystem(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filesystem = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("vaktyxykiirgshbg")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("qgprewxdschixeac")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("geigkiwejhexejgv")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("mtnvkhwstuscekns")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Either<String, ServiceDataAccessAuthIdentity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("clwxwggqtkprujct")
    public fun serviceDataAccessAuthIdentity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("qeurfpcvqvtabcan")
    public fun serviceDataAccessAuthIdentity(`value`: ServiceDataAccessAuthIdentity) {
        val toBeMapped = Either.ofRight<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ublrgensitnmaugc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ivndbxikxwunexma")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureDataLakeGen2DatastoreArgs = AzureDataLakeGen2DatastoreArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        datastoreType = datastoreType ?: throw PulumiNullFieldException("datastoreType"),
        description = description,
        endpoint = endpoint,
        filesystem = filesystem ?: throw PulumiNullFieldException("filesystem"),
        properties = properties,
        protocol = protocol,
        serviceDataAccessAuthIdentity = serviceDataAccessAuthIdentity,
        tags = tags,
    )
}
