@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AzureDevOpsWebhookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Webhook details specific for Azure DevOps
 * @property eventType Send callback on a specified notification event
 * @property webhookType Enum to determine the webhook callback service type.
 * Expected value is 'AzureDevOps'.
 */
public data class AzureDevOpsWebhookArgs(
    public val eventType: Output<String>? = null,
    public val webhookType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AzureDevOpsWebhookArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDevOpsWebhookArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDevOpsWebhookArgs.builder()
            .eventType(eventType?.applyValue({ args0 -> args0 }))
            .webhookType(webhookType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDevOpsWebhookArgs].
 */
@PulumiTagMarker
public class AzureDevOpsWebhookArgsBuilder internal constructor() {
    private var eventType: Output<String>? = null

    private var webhookType: Output<String>? = null

    /**
     * @param value Send callback on a specified notification event
     */
    @JvmName("arxnwdnykwsjfawp")
    public suspend fun eventType(`value`: Output<String>) {
        this.eventType = value
    }

    /**
     * @param value Enum to determine the webhook callback service type.
     * Expected value is 'AzureDevOps'.
     */
    @JvmName("ffoocpyeywasahet")
    public suspend fun webhookType(`value`: Output<String>) {
        this.webhookType = value
    }

    /**
     * @param value Send callback on a specified notification event
     */
    @JvmName("vohjjpjwdstlvkyt")
    public suspend fun eventType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventType = mapped
    }

    /**
     * @param value Enum to determine the webhook callback service type.
     * Expected value is 'AzureDevOps'.
     */
    @JvmName("rlospcjaiwhitcei")
    public suspend fun webhookType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.webhookType = mapped
    }

    internal fun build(): AzureDevOpsWebhookArgs = AzureDevOpsWebhookArgs(
        eventType = eventType,
        webhookType = webhookType ?: throw PulumiNullFieldException("webhookType"),
    )
}
