@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AzureFileDatastoreArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ServiceDataAccessAuthIdentity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure File datastore configuration.
 * @property accountName [Required] Storage account name.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureFile'.
 * @property description The asset description text.
 * @property endpoint Azure cloud endpoint for the storage account.
 * @property fileShareName [Required] The name of the Azure file share that the datastore points to.
 * @property properties The asset property dictionary.
 * @property protocol Protocol used to communicate with the storage account.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureFileDatastoreArgs(
    public val accountName: Output<String>,
    public val credentials: Output<Any>,
    public val datastoreType: Output<String>,
    public val description: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val fileShareName: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
    public val protocol: Output<String>? = null,
    public val serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AzureFileDatastoreArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AzureFileDatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AzureFileDatastoreArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .credentials(credentials.applyValue({ args0 -> args0 }))
            .datastoreType(datastoreType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .fileShareName(fileShareName.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .serviceDataAccessAuthIdentity(
                serviceDataAccessAuthIdentity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureFileDatastoreArgs].
 */
@PulumiTagMarker
public class AzureFileDatastoreArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var credentials: Output<Any>? = null

    private var datastoreType: Output<String>? = null

    private var description: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var fileShareName: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var protocol: Output<String>? = null

    private var serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Storage account name.
     */
    @JvmName("gnoahinxuhicqydn")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("qvchdtpkqpgehrcl")
    public suspend fun credentials(`value`: Output<Any>) {
        this.credentials = value
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureFile'.
     */
    @JvmName("tjjaxslvejudkbrs")
    public suspend fun datastoreType(`value`: Output<String>) {
        this.datastoreType = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("qmqbcyfewjmthohq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("vjgyeiyvwncpdpnf")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value [Required] The name of the Azure file share that the datastore points to.
     */
    @JvmName("lpbmhrtanltduivc")
    public suspend fun fileShareName(`value`: Output<String>) {
        this.fileShareName = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("hptyqfmdlxduqmtk")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("wexqvlvxssjdcyww")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("qscnluhdsttulgro")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Output<Either<String, ServiceDataAccessAuthIdentity>>) {
        this.serviceDataAccessAuthIdentity = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jqaeqbqonbipifwu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Storage account name.
     */
    @JvmName("tigghkysqknkmkqk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("kdddenanxvedmnfx")
    public suspend fun credentials(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureFile'.
     */
    @JvmName("qysbfjujbhrmsmcy")
    public suspend fun datastoreType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("nkbmdejyqhemskpd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("liktmhcodyirgqbu")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value [Required] The name of the Azure file share that the datastore points to.
     */
    @JvmName("lgsbyctlkmxnjlua")
    public suspend fun fileShareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileShareName = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("wntihblejjarggnp")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("skleoplrahpauaqd")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("japyxrecqgjkrjlg")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("sclekehgxehhlxin")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Either<String, ServiceDataAccessAuthIdentity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("wscmajcvlttolpbd")
    public fun serviceDataAccessAuthIdentity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("cxvggdhyoysenshi")
    public fun serviceDataAccessAuthIdentity(`value`: ServiceDataAccessAuthIdentity) {
        val toBeMapped = Either.ofRight<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jlhpcvwhandabsbd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ofpfpjtwgronmjfm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureFileDatastoreArgs = AzureFileDatastoreArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        datastoreType = datastoreType ?: throw PulumiNullFieldException("datastoreType"),
        description = description,
        endpoint = endpoint,
        fileShareName = fileShareName ?: throw PulumiNullFieldException("fileShareName"),
        properties = properties,
        protocol = protocol,
        serviceDataAccessAuthIdentity = serviceDataAccessAuthIdentity,
        tags = tags,
    )
}
